/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.service.impl.product;

import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.entity.Description;
import com.rocoinfo.rocomall.repository.DescriptionDao;
import com.rocoinfo.rocomall.service.impl.UploadService;
import com.rocoinfo.rocomall.service.product.IDescriptionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DescriptionService
extends CrudService<DescriptionDao, Description>
implements IDescriptionService {
    @Autowired
    private UploadService uploadService;

    @Override
    public void insert(Description description) {
        description.setIntroduction(this.uploadService.submitHtml(description.getIntroduction()));
        description.setSpecification(this.uploadService.submitHtml(description.getSpecification()));
        description.setPackingList(this.uploadService.submitHtml(description.getPackingList()));
        description.setAfterSale(this.uploadService.submitHtml(description.getAfterSale()));
        super.insert(description);
    }

    @Override
    public void update(Description description) {
        if (description.getIntroduction() != null || description.getAfterSale() != null || description.getPackingList() != null || description.getSpecification() != null) {
            Description oldDescription = ((DescriptionDao)this.entityDao).findByProductId(description.getProductId());
            if (description.getIntroduction() != null) {
                description.setIntroduction(this.uploadService.updateHtml(oldDescription.getIntroduction(), description.getIntroduction()));
            }
            if (description.getSpecification() != null) {
                description.setSpecification(this.uploadService.updateHtml(oldDescription.getSpecification(), description.getSpecification()));
            }
            if (description.getPackingList() != null) {
                description.setPackingList(this.uploadService.updateHtml(oldDescription.getPackingList(), description.getPackingList()));
            }
            if (description.getAfterSale() != null) {
                description.setAfterSale(this.uploadService.updateHtml(oldDescription.getAfterSale(), description.getAfterSale()));
            }
            super.update(description);
        }
    }

    public void delete(Long productId) {
        Description description = this.findByProductId(productId);
        super.deleteById(productId);
        this.uploadService.deleteByPathInHtml(description.getIntroduction());
        this.uploadService.deleteByPathInHtml(description.getSpecification());
        this.uploadService.deleteByPathInHtml(description.getPackingList());
        this.uploadService.deleteByPathInHtml(description.getAfterSale());
    }

    @Override
    public Description findByProductId(Long productId) {
        return ((DescriptionDao)this.entityDao).findByProductId(productId);
    }
}

