/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.service.impl.product;

import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.ProdStockApply;
import com.rocoinfo.rocomall.entity.ProdStockApplyItem;
import com.rocoinfo.rocomall.entity.Sku;
import com.rocoinfo.rocomall.entity.StockApprove;
import com.rocoinfo.rocomall.entity.account.AdminUser;
import com.rocoinfo.rocomall.entity.cent.Apply;
import com.rocoinfo.rocomall.entity.cent.Approve;
import com.rocoinfo.rocomall.repository.ProdStockApplyDao;
import com.rocoinfo.rocomall.repository.ProdStockApplyItemDao;
import com.rocoinfo.rocomall.repository.ProdStockApproveDao;
import com.rocoinfo.rocomall.service.IAdminUserService;
import com.rocoinfo.rocomall.service.product.IProdStockApplyService;
import com.rocoinfo.rocomall.service.product.ISkuService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(isolation=Isolation.REPEATABLE_READ)
public class ProdStockApplyService
extends CrudService<ProdStockApplyDao, ProdStockApply>
implements IProdStockApplyService {
    @Autowired
    private ISkuService skuService;
    @Autowired
    private ProdStockApplyItemDao prodStockApplyItemDao;
    @Autowired
    private ProdStockApproveDao prodStockApproveDao;
    @Autowired
    private IAdminUserService adminUserService;

    @Override
    public StatusDto addOrUpdateStockApply(ProdStockApply prodStockApply, boolean checkFlag) {
        if (checkFlag) {
            for (ProdStockApplyItem itemInfo : prodStockApply.getProdStockApplyItems()) {
                Sku sku = (Sku)this.skuService.getById(itemInfo.getProd().getId());
                int stockQuantity = 0;
                stockQuantity = ProdStockApply.WareHouse.GOOD.equals((Object)prodStockApply.getWarehouse()) ? sku.getStock().intValue() : sku.getVirtualStock().intValue();
                if (itemInfo.getQuantity() <= stockQuantity) continue;
                return StatusDto.buildFailureStatusDto("\u5546\u54c1\uff1a " + sku.getName() + "\u5e93\u5b58\u4e0d\u8db3\u3002 \u5b9e\u9645\u5e93\u5b58\uff1a " + sku.getStock().toString() + "\u4ef6");
            }
        }
        if (prodStockApply.getId() != null) {
            this.prodStockApplyItemDao.deleteByApplyId(prodStockApply.getId());
            this.update(prodStockApply);
        } else {
            this.insert(prodStockApply);
        }
        for (ProdStockApplyItem applyItem : prodStockApply.getProdStockApplyItems()) {
            applyItem.setApplyId(prodStockApply.getId());
            this.prodStockApplyItemDao.insert(applyItem);
        }
        return StatusDto.buildSuccessStatusDto("\u64cd\u4f5c\u6210\u529f!");
    }

    @Override
    public StatusDto auditStockAppoly(StockApprove approve, Approve.ApproveResult result) {
        ProdStockApply prodStockApply = (ProdStockApply)approve.getApply();
        if (Approve.ApproveResult.AGREE.equals((Object)result)) {
            if (ProdStockApply.StockType.OUT.equals((Object)prodStockApply.getType())) {
                for (ProdStockApplyItem item : prodStockApply.getProdStockApplyItems()) {
                    Sku sku = (Sku)this.skuService.getById(item.getProd().getId());
                    int stockQuantity = 0;
                    stockQuantity = ProdStockApply.WareHouse.GOOD.equals((Object)prodStockApply.getWarehouse()) ? sku.getStock().intValue() : sku.getVirtualStock().intValue();
                    if (item.getQuantity() <= stockQuantity) continue;
                    return StatusDto.buildFailureStatusDto("\u5546\u54c1\uff1a " + sku.getName() + "\u5e93\u5b58\u4e0d\u8db3\u3002 \u5b9e\u9645\u5e93\u5b58\uff1a " + sku.getStock().toString() + "\u4ef6");
                }
            }
            ((ProdStockApply)approve.getApply()).setProdStockApplyItems(this.prodStockApplyItemDao.getByApplyId(prodStockApply.getId()));
        }
        this.prodStockApproveDao.insert(approve);
        ProdStockApply newApply = new ProdStockApply();
        newApply.setId(prodStockApply.getId());
        newApply.setState(this.judgeApplyState(result));
        this.update(newApply);
        return StatusDto.buildSuccessStatusDto();
    }

    private Apply.State judgeApplyState(Approve.ApproveResult result) {
        if (Approve.ApproveResult.AGREE.equals((Object)result)) {
            return Apply.State.PASS;
        }
        if (Approve.ApproveResult.DISAGREE.equals((Object)result)) {
            return Apply.State.FAILED;
        }
        if (Approve.ApproveResult.RETURN.equals((Object)result)) {
            return Apply.State.DRAFT;
        }
        return null;
    }

    @Override
    public ProdStockApply getById(Long id) {
        ProdStockApply prodStockApply = (ProdStockApply)((ProdStockApplyDao)this.entityDao).getById(id);
        List<ProdStockApplyItem> applyItemList = this.prodStockApplyItemDao.getByApplyId(prodStockApply.getId());
        for (ProdStockApplyItem info : applyItemList) {
            Sku sku = (Sku)this.skuService.getById(info.getProd().getId());
            this.skuService.buildDetail(sku);
            info.setProd(sku);
        }
        prodStockApply.setProdStockApplyItems(applyItemList);
        List<StockApprove> approveList = this.prodStockApproveDao.getByApplyId(id);
        if (approveList.size() > 0) {
            for (StockApprove info : approveList) {
                info.setApprover((AdminUser)this.adminUserService.getById(info.getApprover().getId()));
            }
            prodStockApply.setStockApproveList(approveList);
        }
        return prodStockApply;
    }
}

