/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.service.impl.product;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.common.service.ServiceException;
import com.rocoinfo.rocomall.dto.SkuCentDiscountDto;
import com.rocoinfo.rocomall.entity.Brand;
import com.rocoinfo.rocomall.entity.Catalog;
import com.rocoinfo.rocomall.entity.PriceHistory;
import com.rocoinfo.rocomall.entity.Product;
import com.rocoinfo.rocomall.entity.ProductCatalog;
import com.rocoinfo.rocomall.entity.ProductImage;
import com.rocoinfo.rocomall.entity.Sku;
import com.rocoinfo.rocomall.entity.Supplier;
import com.rocoinfo.rocomall.redis.JedisTemplate;
import com.rocoinfo.rocomall.repository.SkuDao;
import com.rocoinfo.rocomall.service.impl.product.ProductCatalogService;
import com.rocoinfo.rocomall.service.product.IBrandService;
import com.rocoinfo.rocomall.service.product.IDescriptionService;
import com.rocoinfo.rocomall.service.product.IPriceHistoryService;
import com.rocoinfo.rocomall.service.product.IProductCatalogService;
import com.rocoinfo.rocomall.service.product.IProductImageService;
import com.rocoinfo.rocomall.service.product.IProductService;
import com.rocoinfo.rocomall.service.product.ISkuService;
import com.rocoinfo.rocomall.service.product.ISupplierService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.springframework.aop.framework.AopContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SkuService
extends CrudService<SkuDao, Sku>
implements ISkuService {
    @Autowired
    private IDescriptionService descriptionService;
    @Autowired
    private IProductService productService;
    @Autowired
    private ISupplierService supplierService;
    @Autowired
    private IBrandService brandService;
    @Autowired
    private IProductImageService productImageService;
    @Autowired
    private IProductCatalogService productCatalogService;
    @Autowired
    private JedisTemplate jedisTemplate;
    @Autowired
    private ProductCatalogService prodCataService;
    @Autowired
    private IPriceHistoryService priceHistoryService;

    @Override
    public List<Sku> findAllListedSkuWithProdCatalogAndImgs() {
        List<Sku> skuList = ((SkuDao)this.entityDao).findAllListedSkuWithProd();
        if (!CollectionUtils.isEmpty(skuList)) {
            this.loadImages(skuList);
            List allProdCatalog = this.prodCataService.findAll();
            ArrayListMultimap prodMutiCataIdMap = ArrayListMultimap.create();
            for (ProductCatalog prodCata : allProdCatalog) {
                prodMutiCataIdMap.put((Object)prodCata.getProductId(), (Object)new Catalog(prodCata.getCatalogId()));
            }
            for (Sku sku : skuList) {
                sku.getProduct().setCatalogs(prodMutiCataIdMap.get((Object)sku.getProduct().getId()));
            }
        }
        return skuList;
    }

    public List<Sku> getByProductId(Long productId) {
        return ((SkuDao)this.entityDao).getByProductId(productId);
    }

    public List<Sku> findByIdIn(List<Long> ids) {
        ArrayList<Sku> skus = new ArrayList<Sku>(ids.size());
        for (Long id : ids) {
            skus.add((Sku)this.getById(id));
        }
        return skus;
    }

    @Override
    public List<Sku> findSkuWithProdByIdIn(List<Long> skuIds, boolean isLoadSkuImg) {
        if (CollectionUtils.isEmpty(skuIds)) {
            return Collections.emptyList();
        }
        List<Sku> skuList = ((SkuDao)this.entityDao).findSkuWithProdByIdIn(skuIds);
        if (isLoadSkuImg) {
            this.loadImages(skuList);
        }
        return skuList;
    }

    @Override
    public Sku buildDetail(Long skuId, boolean isLoadImg) {
        if (skuId == null) {
            return null;
        }
        Sku sku = ((SkuDao)this.entityDao).findSkuWithProdBySkuId(skuId);
        return sku;
    }

    @Override
    public void buildDetail(Sku sku) {
        if (sku != null) {
            sku.setProductImages(this.productImageService.getBySkuId(sku.getId()));
            Product product = (Product)this.productService.getById(sku.getProduct().getId());
            if (product != null) {
                product.setSupplier((Supplier)this.supplierService.getById(product.getSupplier().getId()));
                if (product.getBrand() != null) {
                    product.setBrand((Brand)this.brandService.getById(product.getBrand().getId()));
                }
                product.setCatalogs(this.productCatalogService.findCatalogByProductId(product.getId()));
                product.setDescription(this.descriptionService.findByProductId(product.getId()));
                product.setProductImages(this.productImageService.getProductPrimaryImages(product.getId()));
                sku.setProduct(product);
            }
        }
    }

    @Override
    public void loadImages(List<Sku> skuList) {
        if (!CollectionUtils.isEmpty(skuList)) {
            ArrayList prodIds = Lists.newArrayList();
            for (Sku sku : skuList) {
                if (prodIds.contains(sku.getProduct().getId())) continue;
                prodIds.add(sku.getProduct().getId());
            }
            List<ProductImage> prodImgList = this.productImageService.findByProductIdIn(prodIds);
            if (!CollectionUtils.isEmpty(prodImgList)) {
                for (Sku sku : skuList) {
                    for (ProductImage prodImg : prodImgList) {
                        if (!prodImg.getProduct().getId().equals(sku.getProduct().getId())) continue;
                        if (prodImg.getSku() == null) {
                            sku.getProduct().addImage(prodImg);
                            continue;
                        }
                        if (!prodImg.getSku().getId().equals(sku.getId())) continue;
                        sku.addImage(prodImg);
                    }
                }
            }
        }
    }

    @Override
    public void buildCartSkuDetail(Sku sku) {
        sku.setProductImages(this.productImageService.getBySkuId(sku.getId()));
        Product product = (Product)this.productService.getById(sku.getProduct().getId());
        if (product != null) {
            product.setSupplier((Supplier)this.supplierService.getById(product.getSupplier().getId()));
            product.setProductImages(this.productImageService.getProductPrimaryImages(product.getId()));
            sku.setProduct(product);
        }
    }

    @Override
    public List<SkuCentDiscountDto> findSkuCentAndDicountByIdIn(List<Long> skuIds) {
        if (CollectionUtils.isEmpty(skuIds)) {
            return Collections.emptyList();
        }
        ArrayList skuCentDiscDtoList = Lists.newArrayList();
        List<Map<String, Object>> mapList = ((SkuDao)this.entityDao).findSkuCentAndDicountByIdIn(skuIds);
        for (Map<String, Object> rowItem : mapList) {
            Integer id = (Integer)rowItem.get("id");
            Integer cent = ((BigDecimal)rowItem.get("cent")).intValue();
            SkuCentDiscountDto centDiscountDto = new SkuCentDiscountDto();
            centDiscountDto.setSkuId(id.intValue());
            centDiscountDto.setCent(cent);
            skuCentDiscDtoList.add(centDiscountDto);
        }
        return skuCentDiscDtoList;
    }

    @Override
    public Long getSkuIdByAttributes(Long productId, String attribute1, String attribute2, String attribute3) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("productId", productId);
        params.put("attribute1", attribute1);
        if (StringUtils.isNotBlank((CharSequence)attribute2)) {
            params.put("attribute2", attribute2);
        }
        if (StringUtils.isNotBlank((CharSequence)attribute3)) {
            params.put("attribute3", attribute3);
        }
        return ((SkuDao)this.entityDao).getSkuIdByAttributes(params);
    }

    @Override
    public void insert(Sku sku) {
        if (this.countByCode(sku.getCode()) > 0) {
            throw new ServiceException("SKU\u7f16\u7801 " + sku.getCode() + " \u5df2\u5b58\u5728");
        }
        sku.setName(sku.getProductFullName());
        sku.setOrigCashAmt(0.0);
        sku.setOrigCent(0);
        sku.setOrigMergeCashAmt(0.0);
        sku.setOrigMergeCent(0.0);
        super.insert(sku);
        if (sku.getProductImages() != null) {
            for (int i = 0; i < sku.getProductImages().size(); ++i) {
                ProductImage productImage = sku.getProductImages().get(i);
                if (StringUtils.isBlank((CharSequence)productImage.getPath())) continue;
                productImage.setSku(sku);
                productImage.setProduct(sku.getProduct());
                productImage.setDisplayOrder(i);
                productImage.setImageType(ProductImage.ImageType.SKU);
                this.productImageService.insert(productImage);
            }
        }
    }

    @Override
    public void update(Sku sku, Long userId) {
        Sku oldSku;
        if (sku.getId() != null && ((oldSku = (Sku)super.getById(sku.getId())).getCashAmt() != sku.getCashAmt() || oldSku.getCent() != sku.getCent() || oldSku.getMergeCashAmt() != sku.getMergeCashAmt() || oldSku.getMergeCent() != sku.getMergeCent())) {
            sku.setOrigCashAmt(oldSku.getCashAmt());
            sku.setOrigCent(oldSku.getCent());
            sku.setOrigMergeCashAmt(oldSku.getMergeCashAmt());
            sku.setOrigMergeCent(oldSku.getMergeCent());
            this.insertPriceHistory(oldSku, userId);
        }
        sku.setAttribute1(StringUtils.trimToNull((String)sku.getAttribute1()));
        sku.setAttribute2(StringUtils.trimToNull((String)sku.getAttribute2()));
        sku.setAttribute3(StringUtils.trimToNull((String)sku.getAttribute3()));
        super.update(sku);
        if (sku.getProductImages() != null) {
            List<ProductImage> oldProductImages = this.productImageService.getBySkuId(sku.getId());
            this.productImageService.batchUpdate(oldProductImages, sku.getProductImages(), sku.getProduct(), sku);
        }
    }

    private void insertPriceHistory(Sku sku, Long userId) {
        PriceHistory price = new PriceHistory();
        price.setUserId(userId);
        price.setCashAmt(sku.getCashAmt());
        price.setCent(sku.getCent());
        price.setMergeCashAmt(sku.getMergeCashAmt());
        price.setMergeCent(sku.getMergeCent());
        price.setTime(new Date());
        price.setSkuId(sku.getId());
        this.priceHistoryService.insert(price);
    }

    @Override
    public void incrOrDecrOccupiedStock(List<Long> skuIdList, List<Integer> qtyList) {
        if (!CollectionUtils.isEmpty(skuIdList) && !CollectionUtils.isEmpty(qtyList) && skuIdList.size() == qtyList.size()) {
            ((SkuDao)this.entityDao).incrOrDecrOccupiedStock(skuIdList, qtyList);
        }
    }

    @Override
    public void incrOrDecrStock(@Param(value="skuId") Long skuId, @Param(value="quantity") Integer quantity, @Param(value="wareHouseId") Long dictWareHouseId) {
        if (skuId != null && skuId > 0L && quantity != null && quantity != 0) {
            ((SkuDao)this.entityDao).incrOrDecrStock(skuId, quantity, dictWareHouseId);
        }
    }

    @Override
    @Deprecated
    public void batchIncreaseOccupiedStockAndSaleVolumeOnPayed(List<Long> skuIdList, List<Integer> quantityList) {
        if (!CollectionUtils.isEmpty(skuIdList) && !CollectionUtils.isEmpty(quantityList) && skuIdList.size() == quantityList.size()) {
            ((SkuDao)this.entityDao).batchIncreaseOccupiedStockAndSaleVolumeOnPayed(skuIdList, quantityList);
            this.batchClearCachedSkus(skuIdList);
        }
    }

    @Override
    @Deprecated
    public void decreaseOccupiedStockAndSaleVolumeOnCancel(long skuId, int quantity) {
        if (skuId > 0L && quantity > 0) {
            ((SkuDao)this.entityDao).decreaseOccupiedStockAndSaleVolumeOnCancel(skuId, quantity);
        }
    }

    @Override
    @Deprecated
    public void decreaseStockAndOccupiedOnSend(long skuId, int quantity) {
        if (skuId > 0L && quantity > 0) {
            ((SkuDao)this.entityDao).decreaseStockAndOccupiedOnSend(skuId, quantity);
        }
    }

    @Override
    @Deprecated
    public void decrStockAndIncrDefectStockOnExchange(long skuId, int quantity) {
        if (skuId > 0L && quantity > 0) {
            ((SkuDao)this.entityDao).decrStockAndIncrDefectStockOnExchange(skuId, quantity);
        }
    }

    @Override
    @Deprecated
    public void increaseStockOnRefundIfCanUse(long skuId, int quantity) {
        if (skuId > 0L && quantity > 0) {
            ((SkuDao)this.entityDao).increaseStockOnRefundIfCanUse(skuId, quantity);
        }
    }

    @Override
    @Deprecated
    public void batchDecreaseStockAndOccupiedOnImport(List<Long> skuIdList, List<Integer> quantityList) {
        if (!CollectionUtils.isEmpty(skuIdList) && !CollectionUtils.isEmpty(quantityList) && skuIdList.size() == quantityList.size()) {
            ((SkuDao)this.entityDao).batchDecreaseStockAndOccupiedOnImport(skuIdList, quantityList);
            this.batchClearCachedSkus(skuIdList);
        }
    }

    @Override
    public void batchClearCachedSkus(List<Long> skuIdList) {
        String skuCacheKeyPrev = "'cache.sku.'+";
        skuCacheKeyPrev = StringUtils.substringBetween((String)skuCacheKeyPrev, (String)"'");
        ArrayList skuCacheKeyList = Lists.newArrayListWithExpectedSize((int)skuIdList.size());
        for (Long skuId : skuIdList) {
            skuCacheKeyList.add(skuCacheKeyPrev + skuId);
        }
        this.jedisTemplate.del(skuCacheKeyList.toArray(new String[0]));
    }

    public int countByCode(String code) {
        return ((SkuDao)this.entityDao).countByCode(code);
    }

    public void setListedActivityColumnsNull(Long id) {
        Sku sku = (Sku)super.getById(id);
        ((SkuDao)this.entityDao).setListedActivityColumnsNull(id);
    }

    public Page<Sku> adminSearchJoin(Map<String, Object> parameters, Pageable pageable) {
        List<Object> content;
        Long total = ((SkuDao)this.entityDao).adminSearchTotalJoin(parameters);
        if (total > (long)pageable.getOffset()) {
            parameters.put("offset", pageable.getOffset());
            parameters.put("pageSize", pageable.getPageSize());
            parameters.put("sort", pageable.getSort());
            content = ((SkuDao)this.entityDao).adminSearchJoin(parameters);
        } else {
            content = Collections.emptyList();
        }
        return new PageImpl(content, pageable, total.longValue());
    }

    private SkuService getProxy() {
        return (SkuService)AopContext.currentProxy();
    }

    @Override
    public Sku getByCode(String code) {
        return ((SkuDao)this.entityDao).getByCode(code);
    }

    @Override
    public boolean isVirtualProduct(Long skuId) {
        Sku sku = (Sku)super.getById(skuId);
        return sku != null && ((Product)this.productService.getById(sku.getProduct().getId())).getVisual() != false;
    }
}

