/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.service.impl.workorder;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.entity.order.OrderItem;
import com.rocoinfo.rocomall.entity.workorder.WorkOrderRefundDetail;
import com.rocoinfo.rocomall.repository.workorder.WorkOrderRefundDetailDao;
import com.rocoinfo.rocomall.service.impl.order.OrderItemService;
import com.rocoinfo.rocomall.service.workorder.IWorkOrderRefundDetailService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WorkOrderRefundDetailService
extends CrudService<WorkOrderRefundDetailDao, WorkOrderRefundDetail>
implements IWorkOrderRefundDetailService {
    @Autowired
    private OrderItemService orderItemService;

    @Override
    public Map<Long, Integer> countUnReceiveNumOfWorkOrder(List<Long> workOrderIdList) {
        if (CollectionUtils.isEmpty(workOrderIdList)) {
            return Collections.emptyMap();
        }
        HashMap unReceiveNumMap = Maps.newHashMap();
        List<Map<String, Object>> rowItemList = ((WorkOrderRefundDetailDao)this.entityDao).countUnReceiveNumOfWorkOrder(workOrderIdList);
        for (Map<String, Object> rowItem : rowItemList) {
            Integer workOrderId = (Integer)rowItem.get("workOrderId");
            int num = ((BigDecimal)rowItem.get("unConfirmReceiveNum")).intValue();
            unReceiveNumMap.put(Long.valueOf(workOrderId.intValue()), num);
        }
        return unReceiveNumMap;
    }

    @Override
    public List<WorkOrderRefundDetail> findByWorkOrderId(Long workOrderId) {
        if (workOrderId == null || workOrderId < 1L) {
            return Collections.emptyList();
        }
        return ((WorkOrderRefundDetailDao)this.entityDao).findByWorkOrderId(workOrderId);
    }

    @Override
    @Transactional
    public void saveWorkOrderRefundDetails(List<WorkOrderRefundDetail> refundDetailList) {
        if (CollectionUtils.isNotEmpty(refundDetailList)) {
            ArrayList subOrderIdList = Lists.newArrayList();
            for (WorkOrderRefundDetail item : refundDetailList) {
                this.insert(item);
                subOrderIdList.add(item.getOrderItem().getId());
            }
            this.orderItemService.batchUpdateStatus(OrderItem.Status.REFUND_ACCEPT, OrderItem.AdmStatus.REFUND_ACCEPT, subOrderIdList);
        }
    }
}

