/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.service.impl.workorder;

import com.google.common.collect.Lists;
import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.entity.account.AdminUser;
import com.rocoinfo.rocomall.entity.dict.express.DictExpress;
import com.rocoinfo.rocomall.entity.order.InstoreOrder;
import com.rocoinfo.rocomall.entity.order.OrderItem;
import com.rocoinfo.rocomall.entity.workorder.WorkOrder;
import com.rocoinfo.rocomall.entity.workorder.WorkOrderRefundDetail;
import com.rocoinfo.rocomall.repository.workorder.WorkOrderDao;
import com.rocoinfo.rocomall.service.impl.order.InstoreOrderService;
import com.rocoinfo.rocomall.service.order.IOrderItemService;
import com.rocoinfo.rocomall.service.workorder.IWorkOrderRefundDetailService;
import com.rocoinfo.rocomall.service.workorder.IWorkOrderService;
import com.rocoinfo.rocomall.utils.CodeGenerator;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WorkOrderService
extends CrudService<WorkOrderDao, WorkOrder>
implements IWorkOrderService {
    @Autowired
    private IOrderItemService orderItemService;
    @Autowired
    private IWorkOrderRefundDetailService workOrderRefundDetailService;
    @Autowired
    private CodeGenerator codeGenerator;
    @Autowired
    private InstoreOrderService instoreOrderService;

    @Override
    @Transactional
    public void closeWorkOrder(WorkOrder workOrder) {
        if (workOrder != null) {
            List<WorkOrderRefundDetail> refundDetailList;
            ((WorkOrderDao)this.entityDao).update(workOrder);
            if (WorkOrder.Type.REFUND.equals((Object)workOrder.getType()) && CollectionUtils.isNotEmpty(refundDetailList = this.workOrderRefundDetailService.findByWorkOrderId(workOrder.getId()))) {
                int refundCentTotal = 0;
                double refundAmtTotal = 0.0;
                ArrayList orderItemIdList = Lists.newArrayList();
                for (WorkOrderRefundDetail detail : refundDetailList) {
                    orderItemIdList.add(detail.getOrderItem().getId());
                    refundCentTotal += detail.getCent();
                    refundAmtTotal += detail.getAmount();
                }
                this.orderItemService.batchUpdateStatus(OrderItem.Status.REFUNDED, OrderItem.AdmStatus.REFUNDED, orderItemIdList);
            }
        }
    }

    @Override
    @Transactional
    public void generateRefundInstoreOrders(WorkOrder workOrder, AdminUser operator) {
        DictExpress express = workOrder.getExpress();
        if (WorkOrder.Type.REFUND.equals((Object)workOrder.getType()) && express != null && express.getId() > 0L && StringUtils.isNotBlank((CharSequence)workOrder.getTransportNo())) {
            ArrayList orderItemIdList = Lists.newArrayList();
            List<WorkOrderRefundDetail> refundDetailList = this.workOrderRefundDetailService.findByWorkOrderId(workOrder.getId());
            for (WorkOrderRefundDetail detail : refundDetailList) {
                orderItemIdList.add(detail.getOrderItem().getId());
                InstoreOrder inStoreOrder = new InstoreOrder();
                inStoreOrder.setCode(this.codeGenerator.generateInstoreOrderCode());
                inStoreOrder.setCreateTime(new Date());
                inStoreOrder.setInType(InstoreOrder.InstoreType.REFUND);
                String note = InstoreOrder.InstoreType.REFUND.getLabel() + ",\u5de5\u5355\u53f7:" + workOrder.getCode() + ",\u9000\u8d27\u5b50\u8ba2\u5355\u53f7:" + detail.getOrderItem().getOrderCode();
                inStoreOrder.setNote(note);
                inStoreOrder.setOperator(operator);
                inStoreOrder.setQuantity(detail.getQuantity());
                inStoreOrder.setReceiveState(InstoreOrder.ReceiveStatus.UNFINISHED);
                inStoreOrder.setSku(detail.getSku());
                inStoreOrder.setWarehouse(detail.getWarehouse());
                inStoreOrder.setOrderCode(detail.getOrderItem().getOrderCode());
                inStoreOrder.setRefundDetailId(detail.getId());
                this.instoreOrderService.insert(inStoreOrder);
            }
            this.orderItemService.batchUpdateStatus(OrderItem.Status.REFUNDED, OrderItem.AdmStatus.REFUNDED, orderItemIdList);
        }
    }
}

