/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.utils;

import com.rocoinfo.rocomall.entity.cent.CentRule;
import com.rocoinfo.rocomall.entity.order.OrderItem;
import com.rocoinfo.rocomall.redis.JedisTemplate;
import com.rocoinfo.rocomall.service.ISequenceService;
import com.rocoinfo.rocomall.service.impl.SequenceService;
import com.rocoinfo.rocomall.utils.RandomTools;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CodeGenerator {
    @Autowired
    private JedisTemplate jedisTemplate;
    @Autowired
    private ISequenceService sequenceService;
    private static final SimpleDateFormat ymdHmsFormat = new SimpleDateFormat("yyMMddHHmmss");
    private static final SimpleDateFormat ymdHmFormat = new SimpleDateFormat("yyMMddHHmm");
    private static final SimpleDateFormat ymdFormat = new SimpleDateFormat("yyMMdd");

    public static String generateAccessToken() {
        StringBuilder tokenBuf = new StringBuilder();
        tokenBuf.append(RandomTools.getRandStr(7, 1)).append(RandomTools.getRandStr(1, 2));
        return tokenBuf.toString();
    }

    public static String generateWxMessageId() {
        String dateTimePrefix = ymdHmsFormat.format(new Date());
        String randomNum = RandomTools.getRandStr(5, 2);
        return dateTimePrefix + randomNum;
    }

    public String generateDictPlanCode() {
        return this.generateTableCode(SequenceService.SequenceTable.DICT_PLAN);
    }

    public String generateDictAdvTypeCode() {
        return this.generateTableCode(SequenceService.SequenceTable.ADV_TYPE);
    }

    public String generateCentRuleCode() {
        return this.generateTableCode(SequenceService.SequenceTable.CENT_RULE);
    }

    private String generateTableCode(SequenceService.SequenceTable seqTab) {
        int nextSeq = this.sequenceService.getNextVal(seqTab);
        if (seqTab.getFixWidth() > 0) {
            return StringUtils.leftPad((String)String.valueOf(nextSeq), (int)seqTab.getFixWidth(), (char)'0');
        }
        return String.valueOf(nextSeq);
    }

    public String generateCentApplyCode() {
        return System.currentTimeMillis() + RandomTools.getRandStr(5, 2);
    }

    public String generateCentCode(CentRule rule) {
        StringBuilder sb = new StringBuilder();
        sb.append(rule.getCode());
        String datePart = ymdFormat.format(new Date());
        sb.append(datePart);
        String centCodeSeqKey = "orderCode.seq." + datePart;
        Long seq = this.jedisTemplate.incr(centCodeSeqKey);
        if (seq == 1L) {
            this.jedisTemplate.expire(centCodeSeqKey, 86400);
        }
        String seqPart = StringUtils.leftPad((String)String.valueOf(seq), (int)7, (char)'0');
        sb.append(seqPart);
        return sb.toString();
    }

    public static String generateStockApplyCode(boolean inStock) {
        String prefix = inStock ? "I" : "O";
        String timePart = ymdHmFormat.format(new Date());
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append(timePart).append(RandomTools.getRandStr(7, 2));
        return sb.toString();
    }

    public String generateBudgetCode() {
        String prefix = "BUD";
        String timePart = ymdHmFormat.format(new Date());
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append(timePart).append(RandomTools.getRandStr(7, 2));
        return sb.toString();
    }

    public static String generateUserImportApplyCode() {
        return System.currentTimeMillis() + RandomTools.getRandStr(5, 2);
    }

    public static String generateSecurityKey() {
        String currentTime = System.currentTimeMillis() + "";
        return DigestUtils.md5Hex((byte[])currentTime.substring(0, currentTime.length() - 3).getBytes());
    }

    public String generateCentConsumeSnNum(Date dateTime, String consumeTypeCode) {
        String prefix = consumeTypeCode;
        String datePart = ymdFormat.format(dateTime);
        String orderSeqKey = "consume.sn.seq." + datePart;
        Long seq = this.jedisTemplate.incr(orderSeqKey);
        if (seq == 1L) {
            this.jedisTemplate.expire(orderSeqKey, 86400);
        }
        String seqPart = StringUtils.leftPad((String)String.valueOf(seq), (int)7, (char)'0');
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append(datePart).append(seqPart).append(RandomTools.getRandStr(2, 2));
        return sb.toString();
    }

    public String generateOrderCode(Date dateTime, OrderItem.OrderType orderType) {
        String prefix = orderType.getCode();
        String datePart = ymdFormat.format(dateTime);
        String orderSeqKey = "orderCode.seq." + datePart;
        Long seq = this.jedisTemplate.incr(orderSeqKey);
        if (seq == 1L) {
            this.jedisTemplate.expire(orderSeqKey, 86400);
        }
        String seqPart = StringUtils.leftPad((String)String.valueOf(seq), (int)4, (char)'0');
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append(datePart).append(RandomTools.getRandStr(2, 2)).append(seqPart);
        return sb.toString();
    }

    public String generateInstoreOrderCode() {
        return this.generateTableCode(SequenceService.SequenceTable.INSTORE_CODE);
    }

    public String generateDistributionOrderCode(String subOrderCode) {
        StringBuilder codeBuilder = new StringBuilder();
        codeBuilder.append("P");
        String datePart = ymdHmFormat.format(new Date());
        codeBuilder.append(datePart);
        codeBuilder.append(subOrderCode.substring(subOrderCode.length() - 4));
        codeBuilder.append(RandomTools.getRandStr(3, 2));
        return codeBuilder.toString();
    }

    public String generateOutstoreOrderCode() {
        StringBuilder codeBuilder = new StringBuilder();
        codeBuilder.append("O");
        String datePart = ymdHmFormat.format(new Date());
        codeBuilder.append(datePart);
        codeBuilder.append(RandomTools.getRandStr(4, 2));
        return codeBuilder.toString();
    }

    public String generateWorkOrderCode() {
        String currDate = ymdHmFormat.format(new Date());
        String key = currDate;
        long num = this.jedisTemplate.incr(key);
        if (num <= 1L) {
            this.jedisTemplate.expire(key, 86400000);
        }
        String randPart = RandomTools.getRandStr(2, 2);
        String seqPart = StringUtils.leftPad((String)String.valueOf(num), (int)3, (char)'0');
        return currDate + randPart + seqPart;
    }

    public String generateCompanyCode() {
        return this.generateTableCode(SequenceService.SequenceTable.COMPANY_CODE);
    }
}

