/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.utils;

import com.rocoinfo.rocomall.entity.account.Account;
import org.springside.modules.security.utils.Digests;
import org.springside.modules.utils.Encodes;

public final class PasswordUtil {
    private static final int SALT_SIZE = 8;
    public static final String HASH_ALGORITHM = "SHA-1";
    public static final int HASH_ITERATIONS = 1024;

    public static void entryptPassword(Account account) {
        account.setSalt(PasswordUtil.generateSalt());
        account.setPassword(PasswordUtil.hashPassword(account.getPlainPassword(), account.getSalt()));
    }

    public static String generateSalt() {
        byte[] salt = Digests.generateSalt((int)8);
        return Encodes.encodeHex((byte[])salt);
    }

    public static String hashPassword(String plainPassword, String salt) {
        byte[] hashPassword = Digests.sha1((byte[])plainPassword.getBytes(), (byte[])Encodes.decodeHex((String)salt), (int)1024);
        return Encodes.encodeHex((byte[])hashPassword);
    }

    public static void main(String[] args) {
        Account account = new Account();
        account.setPlainPassword("123456");
        PasswordUtil.entryptPassword(account);
        System.out.println("salt=" + account.getSalt());
        System.out.println("hasPsw=" + account.getPassword());
    }
}

