/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.utils;

import com.rocoinfo.rocomall.utils.HttpUtils;
import java.io.File;
import java.io.FileInputStream;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLContext;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.client.RestTemplate;

public class RestTemplateUtil {
    private static Logger logger = LoggerFactory.getLogger(RestTemplateUtil.class);
    private static RestTemplate restTemplateUtf8 = null;
    private static RestTemplate restTemplateGBK = null;
    private static RestTemplate restTemplateUtf8Https = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RestTemplate getRestTemplateGBK() {
        if (restTemplateGBK != null) return restTemplateGBK;
        Class<RestTemplateUtil> clazz = RestTemplateUtil.class;
        synchronized (RestTemplateUtil.class) {
            if (restTemplateGBK != null) return restTemplateGBK;
            restTemplateGBK = RestTemplateUtil.getRestTemplate(null, null, false, "GBK");
            // ** MonitorExit[var0] (shouldn't be in output)
            return restTemplateGBK;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RestTemplate getRestTemplateUtf8() {
        if (restTemplateUtf8 != null) return restTemplateUtf8;
        Class<RestTemplateUtil> clazz = RestTemplateUtil.class;
        synchronized (RestTemplateUtil.class) {
            if (restTemplateUtf8 != null) return restTemplateUtf8;
            restTemplateUtf8 = RestTemplateUtil.getRestTemplate(null, null, false, "utf-8");
            // ** MonitorExit[var0] (shouldn't be in output)
            return restTemplateUtf8;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RestTemplate getRestTemplateUtf8Https(String password, String path) {
        if (restTemplateUtf8Https != null) return restTemplateUtf8Https;
        Class<RestTemplateUtil> clazz = RestTemplateUtil.class;
        synchronized (RestTemplateUtil.class) {
            if (restTemplateUtf8Https != null) return restTemplateUtf8Https;
            restTemplateUtf8Https = RestTemplateUtil.getRestTemplate(password, path, true, "utf-8");
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return restTemplateUtf8Https;
        }
    }

    private static RestTemplate getRestTemplate(String password, String path, boolean isHttps, String charset) {
        RestTemplate template = null;
        template = isHttps ? new RestTemplate((ClientHttpRequestFactory)new HttpComponentsClientHttpRequestFactory(RestTemplateUtil.getHttpsClient(password, path))) : new RestTemplate((ClientHttpRequestFactory)new HttpComponentsClientHttpRequestFactory(HttpUtils.createHttpClientInstance()));
        ClientHttpRequestFactory f = template.getRequestFactory();
        if (f instanceof HttpComponentsClientHttpRequestFactory) {
            HttpComponentsClientHttpRequestFactory fh = (HttpComponentsClientHttpRequestFactory)f;
            fh.setConnectTimeout(6000);
            fh.setReadTimeout(6000);
        }
        List messageConverters = template.getMessageConverters();
        ArrayList<Object> newMessageConverters = new ArrayList<Object>(messageConverters.size());
        for (HttpMessageConverter converter : messageConverters) {
            if (converter instanceof StringHttpMessageConverter) {
                newMessageConverters.add(new StringHttpMessageConverter(Charset.forName(charset)));
                continue;
            }
            newMessageConverters.add(converter);
        }
        template.setMessageConverters(newMessageConverters);
        return template;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpClient getHttpsClient(String password, String path) {
        try {
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            try (FileInputStream instream = new FileInputStream(new File(path));){
                keyStore.load(instream, password.toCharArray());
            }
            SSLContext sslcontext = SSLContexts.custom().loadKeyMaterial(keyStore, password.toCharArray()).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, new String[]{"TLSv1"}, null, SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
            CloseableHttpClient httpclient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
            return httpclient;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("getHttpsClient error{},", (Object)e.getMessage());
            return null;
        }
    }
}

