/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.saml;

import com.stormpath.sdk.error.Error;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.resource.ResourceException;
import com.stormpath.sdk.saml.InvalidSamlTokenException;
import com.stormpath.sdk.saml.SamlSessionTimeoutException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class SamlRuntimeException
extends ResourceException {
    private static final List<Integer> supportedErrors = Collections.unmodifiableList(Arrays.asList(10100, 10101, 10102, 12001));

    public SamlRuntimeException(Error error) {
        super(error);
        Assert.isTrue(this.supports(error), "error type not supported; must be one of: " + supportedErrors.toString());
    }

    public void rethrow() throws InvalidSamlTokenException, SamlSessionTimeoutException {
        Error error = this.getStormpathError();
        if (error.getCode() == 10100 || error.getCode() == 10101 || error.getCode() == 10102) {
            throw new InvalidSamlTokenException(error);
        }
        if (this.getStormpathError().getCode() == 12001) {
            throw new SamlSessionTimeoutException(error);
        }
        throw new IllegalStateException("error type is unrecognized: " + error.getCode());
    }

    protected boolean supports(Error error) {
        return supportedErrors.contains(error.getCode());
    }
}

