/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tair;

import com.taobao.tair.DataEntry;
import com.taobao.tair.ResultCode;
import java.util.Collection;

public class Result<V> {
    private ResultCode rc;
    private V value;

    public Result(ResultCode rc) {
        this.rc = rc;
    }

    public Result(ResultCode rc, V value) {
        this.rc = rc;
        this.value = value;
    }

    public boolean isSuccess() {
        return this.rc.isSuccess();
    }

    public V getValue() {
        return this.value;
    }

    public ResultCode getRc() {
        return this.rc;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Result: [").append(this.rc.toString()).append("]\n");
        if (this.value != null) {
            if (this.value instanceof DataEntry) {
                sb.append("\t").append(this.value.toString()).append("\n");
            } else if (this.value instanceof Collection) {
                Collection des = (Collection)this.value;
                sb.append("\tentry size: ").append(des.size()).append("\n");
                for (DataEntry de : des) {
                    sb.append("\t").append(de.toString()).append("\n");
                }
            } else {
                sb.append("\tvalue: ").append(this.value);
            }
        }
        return sb.toString();
    }
}

