/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tair.comm;

import com.taobao.tair.comm.ResponseListener;
import com.taobao.tair.etc.TairClientException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.mina.common.IoSession;

public class ResponseCallbackTask {
    private Integer requestId;
    private ResponseListener listener;
    private AtomicBoolean isDone = new AtomicBoolean(false);
    private IoSession iosession;
    private long timeout;

    public ResponseCallbackTask(Integer requestId, ResponseListener listener, IoSession session, long timeout) {
        this.requestId = requestId;
        this.listener = listener;
        this.iosession = session;
        this.timeout = System.currentTimeMillis() + timeout;
    }

    public Integer getRequestId() {
        return this.requestId;
    }

    public ResponseListener getListener() {
        return this.listener;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public AtomicBoolean getIsDone() {
        return this.isDone;
    }

    public void setResponse(Object response) {
        if (!this.isDone.compareAndSet(false, true)) {
            return;
        }
        if (response instanceof TairClientException) {
            this.listener.exceptionCaught(this.iosession, (TairClientException)response);
        } else {
            this.listener.responseReceived(response);
        }
    }
}

