/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tair.comm;

import com.taobao.tair.comm.TairResponse;
import com.taobao.tair.etc.TairUtil;
import com.taobao.tair.packet.BasePacket;
import com.taobao.tair.packet.PacketStreamer;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.CumulativeProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;

public class TairProtocolDecoder
extends CumulativeProtocolDecoder {
    private static final Log LOGGER = LogFactory.getLog(TairProtocolDecoder.class);
    private static final boolean isDebugEnabled = LOGGER.isDebugEnabled();
    private static final int PROTOCOL_HEADER_LENGTH = 16;
    private PacketStreamer pstreamer;

    public TairProtocolDecoder(PacketStreamer pstreamer) {
        this.pstreamer = pstreamer;
    }

    protected boolean doDecode(IoSession session, ByteBuffer in, ProtocolDecoderOutput out) throws Exception {
        int origonPos = in.position();
        int packetLength = in.remaining();
        if (packetLength < 16) {
            in.position(origonPos);
            return false;
        }
        int flag = in.getInt();
        int chid = in.getInt();
        int pcode = in.getInt();
        int len = in.getInt();
        if (flag != 1833067604) {
            throw new IOException("flag error, except: 1833067604, but get " + flag);
        }
        if (in.remaining() < len) {
            in.position(origonPos);
            return false;
        }
        if (isDebugEnabled) {
            String remoteIP = ((InetSocketAddress)session.getRemoteAddress()).toString();
            StringBuilder receiveTimeInfo = new StringBuilder();
            receiveTimeInfo.append("receive response from [").append(remoteIP).append("],time is: ");
            receiveTimeInfo.append(System.currentTimeMillis());
            receiveTimeInfo.append(", channel id: ").append(chid);
            LOGGER.debug((Object)receiveTimeInfo.toString());
        }
        byte[] data = new byte[len];
        in.get(data);
        if (isDebugEnabled) {
            LOGGER.debug((Object)TairUtil.toHex(data));
        }
        BasePacket returnPacket = this.pstreamer.decodePacket(pcode, data);
        TairResponse response = new TairResponse();
        response.setRequestId(chid);
        response.setResponse(returnPacket);
        out.write((Object)response);
        return true;
    }
}

