/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tair.extend.packet.list.request;

import com.taobao.tair.comm.Transcoder;
import com.taobao.tair.extend.packet.LeftOrRight;
import com.taobao.tair.packet.BasePacket;
import java.util.ArrayList;
import java.util.List;

public class RequestLRPushPacket
extends BasePacket {
    private static final int HEADER_LEN = 17;
    private short namespace = 0;
    private short version = 0;
    private int expire = 0;
    private Object key = null;
    private List<Object> values = new ArrayList<Object>();
    private List<byte[]> bytevalues = new ArrayList<byte[]>();

    public RequestLRPushPacket(Transcoder transcoder, LeftOrRight lr) {
        super(transcoder);
        this.pcode = lr == LeftOrRight.IS_L ? 2101 : 2103;
    }

    public RequestLRPushPacket() {
    }

    public void setLeftOrRight(LeftOrRight lr) {
        this.pcode = lr == LeftOrRight.IS_L ? 2101 : 2103;
    }

    @Override
    public int encode() {
        byte[] keybytes = null;
        byte[] valuebytes = null;
        if (this.key == null || this.values.size() == 0) {
            return 3;
        }
        try {
            keybytes = this.transcoder.encode(this.key);
        }
        catch (Throwable e) {
            return 3;
        }
        if (keybytes == null) {
            return 3;
        }
        if (keybytes.length >= 1024) {
            return 1;
        }
        int valueslen = 0;
        for (Object value : this.values) {
            if (value == null) {
                return 3;
            }
            try {
                valuebytes = this.transcoder.encode(value);
            }
            catch (Throwable e) {
                return 3;
            }
            if (valuebytes == null) {
                return 3;
            }
            if (valuebytes.length > 0x100000) {
                return 3;
            }
            if (valuebytes.length >= 1000000) {
                return 2;
            }
            this.bytevalues.add(valuebytes);
            valueslen += valuebytes.length;
        }
        this.writePacketBegin(17 + valueslen + 4 * this.bytevalues.size());
        this.byteBuffer.put((byte)0);
        this.byteBuffer.putShort(this.namespace);
        this.byteBuffer.putShort(this.version);
        this.byteBuffer.putInt(this.expire);
        this.byteBuffer.putInt(keybytes.length);
        this.byteBuffer.put(keybytes);
        this.byteBuffer.putInt(this.bytevalues.size());
        for (byte[] vb : this.bytevalues) {
            this.byteBuffer.putInt(vb.length);
            this.byteBuffer.put(vb);
        }
        this.writePacketEnd();
        return 0;
    }

    @Override
    public boolean decode() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setKey(Object key) {
        this.key = key;
    }

    public Object getKey() {
        return this.key;
    }

    public void addValue(Object o) {
        this.values.add(o);
    }

    public Object getValue(int index) {
        if (index < 0 || index >= this.values.size()) {
            return null;
        }
        return this.values.get(index);
    }

    @Override
    public void setNamespace(short namespace) {
        this.namespace = namespace;
    }

    public short getNamespace(short namespace) {
        return this.namespace;
    }

    @Override
    public void setVersion(short version) {
        this.version = version;
    }

    public int getVersion() {
        return this.version;
    }

    @Override
    public void setExpire(int expire) {
        this.expire = expire;
    }

    public int getExpire() {
        return this.expire;
    }
}

