/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tair.extend.packet.list.response;

import com.taobao.tair.ResultCode;
import com.taobao.tair.comm.Transcoder;
import com.taobao.tair.extend.packet.LeftOrRight;
import com.taobao.tair.extend.packet.ResponsePacketInterface;
import com.taobao.tair.packet.BasePacket;
import java.nio.BufferUnderflowException;
import java.util.ArrayList;
import java.util.List;

public class ResponseLRPopPacket
extends BasePacket
implements ResponsePacketInterface {
    private int configVersion;
    private short version;
    private List<Object> objs = new ArrayList<Object>();
    private int resultCode;

    public ResponseLRPopPacket(Transcoder transcoder, LeftOrRight lr) {
        super(transcoder);
        this.pcode = lr == LeftOrRight.IS_L ? 2200 : 2202;
    }

    @Override
    public boolean decode() {
        try {
            this.configVersion = this.byteBuffer.getInt();
            this.version = this.byteBuffer.getShort();
            this.resultCode = this.byteBuffer.getInt();
            int count = this.byteBuffer.getInt();
            for (int i = 0; i < count; ++i) {
                int size = this.byteBuffer.getInt();
                if (size <= 0) continue;
                Object o = null;
                try {
                    o = this.transcoder.decode(this.byteBuffer.array(), this.byteBuffer.position(), size);
                }
                catch (Throwable e) {
                    this.resultCode = ResultCode.SERIALIZEERROR.getCode();
                    return false;
                }
                if (o != null) {
                    this.objs.add(o);
                }
                this.byteBuffer.position(this.byteBuffer.position() + size);
            }
        }
        catch (BufferUnderflowException e) {
            this.resultCode = ResultCode.SERIALIZEERROR.getCode();
            return false;
        }
        return true;
    }

    public short getVersion() {
        return this.version;
    }

    public List<Object> getValues() {
        return this.objs;
    }

    @Override
    public int getConfigVersion() {
        return this.configVersion;
    }

    public int getResultCode() {
        return this.resultCode;
    }
}

