/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tair.impl;

import com.taobao.tair.comm.ResponseListener;
import com.taobao.tair.comm.TairClient;
import com.taobao.tair.comm.TairClientFactory;
import com.taobao.tair.etc.TairClientException;
import com.taobao.tair.etc.TairUtil;
import com.taobao.tair.packet.BasePacket;
import com.taobao.tair.packet.PacketStreamer;
import com.taobao.tair.packet.RequestGetGroupPacket;
import com.taobao.tair.packet.RequestQueryInfoPacket;
import com.taobao.tair.packet.ResponseGetGroupPacket;
import com.taobao.tair.packet.ResponseQueryInfoPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mina.common.IoSession;

public class ConfigServer
implements ResponseListener {
    private static final Log log = LogFactory.getLog(ConfigServer.class);
    private static final int MURMURHASH_M = 1540483477;
    private String groupName = null;
    private int configVersion = 0;
    private AtomicLong retrieveLastTime = new AtomicLong(0L);
    private List<String> configServerList = new ArrayList<String>();
    private List<Long> serverList;
    private PacketStreamer pstream;
    private int bucketCount = 0;
    private int copyCount = 0;
    private Set<Long> aliveNodes;
    private int masterFailCount;
    private final int MAX_MASTER_FAILCOUNT = 3;
    private TairClientFactory factory;

    public ConfigServer(TairClientFactory factory, String groupName, List<String> configServerList, PacketStreamer pstream) {
        this.groupName = groupName;
        this.pstream = pstream;
        this.masterFailCount = 0;
        this.factory = factory;
        for (String host : configServerList) {
            this.configServerList.add(host.trim());
        }
    }

    protected void resetConfigVersion() {
        this.configVersion = 0;
    }

    protected int findServerIdx(byte[] keyByte) {
        long hash = this.murMurHash(keyByte);
        log.debug((Object)("hashcode: " + hash + ", bucket count: " + this.bucketCount));
        if (this.serverList != null && this.serverList.size() > 0) {
            return (int)(hash %= (long)this.bucketCount);
        }
        return 0;
    }

    public long getServer(byte[] keyByte, boolean isRead) {
        if (this.serverList == null || this.serverList.size() == 0) {
            log.error((Object)"server list is empty");
            return 0L;
        }
        int serverIdx = this.findServerIdx(keyByte);
        long serverIp = 0L;
        serverIp = this.serverList.get(serverIdx);
        log.debug((Object)("oroginal target server: " + TairUtil.idToAddress(serverIp) + " alive server: " + this.aliveNodes));
        if (!this.aliveNodes.contains(serverIp)) {
            serverIp = 0L;
            log.warn((Object)("master server " + TairUtil.idToAddress(serverIp) + " had down"));
        }
        if (serverIp == 0L && isRead) {
            for (int i = 1; i < this.copyCount; ++i) {
                int copyServerIdx = serverIdx + i * this.bucketCount;
                serverIp = this.serverList.get(copyServerIdx);
                log.debug((Object)("read operation try: " + TairUtil.idToAddress(serverIp)));
                if (this.aliveNodes.contains(serverIp)) break;
                serverIp = 0L;
            }
            if (serverIp == 0L) {
                log.warn((Object)"slave servers also had down");
            }
        }
        return serverIp;
    }

    public Map<String, String> grabGroupConfigMap() {
        RequestGetGroupPacket request = new RequestGetGroupPacket(null);
        request.setGroupName(this.groupName);
        request.setConfigVersion(0);
        for (String addr : this.configServerList) {
            log.info((Object)("send request to " + addr));
            ResponseGetGroupPacket response = null;
            try {
                TairClient client = this.factory.get(addr, 1000, this.pstream);
                response = (ResponseGetGroupPacket)client.invoke(request, 500L);
            }
            catch (Exception e) {
                log.error((Object)("get config failed from: " + addr), (Throwable)e);
                continue;
            }
            if (response == null) continue;
            return response.getConfigMap();
        }
        log.error((Object)"get config map null");
        return null;
    }

    public boolean retrieveConfigure() {
        this.retrieveLastTime.set(System.currentTimeMillis());
        RequestGetGroupPacket packet = new RequestGetGroupPacket(null);
        packet.setGroupName(this.groupName);
        packet.setConfigVersion(this.configVersion);
        boolean initSuccess = false;
        for (int i = 0; i < this.configServerList.size(); ++i) {
            String addr = this.configServerList.get(i);
            log.info((Object)("init configs from configserver: " + addr));
            BasePacket returnPacket = null;
            try {
                TairClient client = this.factory.get(addr, 1000, this.pstream);
                returnPacket = (BasePacket)client.invoke(packet, 500L);
            }
            catch (Exception e) {
                log.error((Object)("get config failed from: " + addr), (Throwable)e);
                continue;
            }
            if (returnPacket != null && returnPacket instanceof ResponseGetGroupPacket) {
                ResponseGetGroupPacket r = (ResponseGetGroupPacket)returnPacket;
                this.configVersion = r.getConfigVersion();
                this.bucketCount = r.getBucketCount();
                this.copyCount = r.getCopyCount();
                this.aliveNodes = r.getAliveNodes();
                if (this.aliveNodes == null || this.aliveNodes.isEmpty()) {
                    log.error((Object)"fatal error, no datanode is alive");
                    continue;
                }
                if (log.isInfoEnabled()) {
                    for (Long id : this.aliveNodes) {
                        log.info((Object)("alive datanode: " + TairUtil.idToAddress(id)));
                    }
                }
                if (this.bucketCount <= 0 || this.copyCount <= 0) {
                    throw new IllegalArgumentException("bucket count or copy count can not be 0");
                }
                if (r.getServerList() != null && r.getServerList().size() > 0) {
                    this.serverList = r.getServerList();
                    if (log.isDebugEnabled()) {
                        for (int idx = 0; idx < r.getServerList().size(); ++idx) {
                            log.debug((Object)("+++ " + idx + " => " + TairUtil.idToAddress(r.getServerList().get(idx))));
                        }
                    }
                    if (this.serverList.size() % this.bucketCount != 0) {
                        log.error((Object)("server size % bucket number != 0, server size: " + this.serverList.size() + ", bucket number" + this.bucketCount + ", copyCount: " + this.copyCount));
                        continue;
                    }
                    log.warn((Object)("configuration inited with version: " + this.configVersion + ", bucket count: " + this.bucketCount + ", copyCount: " + this.copyCount));
                    initSuccess = true;
                    break;
                }
                log.warn((Object)"server list from config server is null or size is 0");
                continue;
            }
            log.error((Object)("retrive from config server " + addr + " failed, result: " + returnPacket));
        }
        return initSuccess;
    }

    public Map<String, String> retrieveStat(int qtype, String groupName, long serverId) {
        RequestQueryInfoPacket packet = new RequestQueryInfoPacket(null);
        packet.setGroupName(groupName);
        packet.setQtype(qtype);
        packet.setServerId(serverId);
        Map<String, String> statInfo = null;
        for (int i = 0; i < this.configServerList.size(); ++i) {
            String addr = this.configServerList.get(i);
            BasePacket returnPacket = null;
            try {
                TairClient client = this.factory.get(addr, 1000, this.pstream);
                returnPacket = (BasePacket)client.invoke(packet, 500L);
            }
            catch (Exception e) {
                log.error((Object)("get stat failed " + addr), (Throwable)e);
                continue;
            }
            if (returnPacket != null && returnPacket instanceof ResponseQueryInfoPacket) {
                ResponseQueryInfoPacket r = (ResponseQueryInfoPacket)returnPacket;
                statInfo = r.getKv();
                break;
            }
            log.error((Object)("retrive stat from config server " + addr + " failed, result: " + returnPacket));
        }
        return statInfo;
    }

    public void checkConfigVersion(int version) {
        if (version == this.configVersion) {
            return;
        }
        if (this.retrieveLastTime.get() > System.currentTimeMillis() - 5000L) {
            log.debug((Object)"last check time is less than 5 seconds, need not sync");
            return;
        }
        this.retrieveLastTime.set(System.currentTimeMillis());
        RequestGetGroupPacket packet = new RequestGetGroupPacket(null);
        packet.setGroupName(this.groupName);
        packet.setConfigVersion(this.configVersion);
        for (int i = 0; i < this.configServerList.size(); ++i) {
            if (i == 0 && this.masterFailCount > 3) {
                this.masterFailCount = 0;
                continue;
            }
            String host = this.configServerList.get(i);
            try {
                TairClient client = this.factory.get(host, 1000, this.pstream);
                client.invokeAsync(packet, 500L, this);
                break;
            }
            catch (TairClientException e) {
                log.error((Object)"get client failed", (Throwable)e);
            }
        }
    }

    @Override
    public void responseReceived(Object packet) {
        if (packet != null && packet instanceof ResponseGetGroupPacket) {
            ResponseGetGroupPacket r = (ResponseGetGroupPacket)packet;
            r.decode();
            log.warn((Object)("configuration synced, oldversion: " + this.configVersion + ", new verion: " + r.getConfigVersion()));
            if (this.configVersion == r.getConfigVersion()) {
                return;
            }
            this.aliveNodes = r.getAliveNodes();
            if (this.aliveNodes == null || this.aliveNodes.isEmpty()) {
                log.error((Object)"empty server table received, still use the old one");
            }
            this.configVersion = r.getConfigVersion();
            for (Long id : this.aliveNodes) {
                log.info((Object)("alive node: " + TairUtil.idToAddress(id)));
            }
            if (r.getServerList() != null && r.getServerList().size() > 0) {
                this.serverList = r.getServerList();
                if (log.isDebugEnabled()) {
                    for (int idx = 0; idx < r.getServerList().size(); ++idx) {
                        log.debug((Object)("+++ " + idx + " => " + TairUtil.idToAddress(r.getServerList().get(idx))));
                    }
                }
            } else {
                log.error((Object)("configuration new verion: " + r.getConfigVersion() + " server list is empty!!!!!"));
            }
        }
    }

    @Override
    public void exceptionCaught(IoSession session, TairClientException exception) {
        log.error((Object)"do async request failed", (Throwable)exception);
        if (session.isConnected()) {
            log.error((Object)"session closing");
            session.close();
        }
        ++this.masterFailCount;
    }

    public void close() {
    }

    private long murMurHash(byte[] key) {
        int len;
        int h = 0x61 ^ len;
        int index = 0;
        for (len = key.length; len >= 4; len -= 4) {
            int k = key[index] & 0xFF | key[index + 1] << 8 & 0xFF00 | key[index + 2] << 16 & 0xFF0000 | key[index + 3] << 24;
            k *= 1540483477;
            k ^= k >>> 24;
            h *= 1540483477;
            h ^= (k *= 1540483477);
            index += 4;
        }
        switch (len) {
            case 3: {
                h ^= key[index + 2] << 16;
            }
            case 2: {
                h ^= key[index + 1] << 8;
            }
            case 1: {
                h ^= key[index];
                h *= 1540483477;
            }
        }
        h ^= h >>> 13;
        h *= 1540483477;
        h ^= h >>> 15;
        return (long)h & 0xFFFFFFFFL;
    }
}

