/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tair.packet;

import com.taobao.tair.comm.Transcoder;
import com.taobao.tair.extend.packet.LeftOrRight;
import com.taobao.tair.extend.packet.common.response.ResponseExpirePacket;
import com.taobao.tair.extend.packet.common.response.ResponseTTLPacket;
import com.taobao.tair.extend.packet.common.response.ResponseTypePacket;
import com.taobao.tair.extend.packet.hset.response.ResponseHDelPacket;
import com.taobao.tair.extend.packet.hset.response.ResponseHGetPacket;
import com.taobao.tair.extend.packet.hset.response.ResponseHGetallPacket;
import com.taobao.tair.extend.packet.hset.response.ResponseHIncrbyPacket;
import com.taobao.tair.extend.packet.hset.response.ResponseHLenPacket;
import com.taobao.tair.extend.packet.hset.response.ResponseHMgetPacket;
import com.taobao.tair.extend.packet.hset.response.ResponseHMsetPacket;
import com.taobao.tair.extend.packet.hset.response.ResponseHSetPacket;
import com.taobao.tair.extend.packet.hset.response.ResponseHValsPacket;
import com.taobao.tair.extend.packet.list.response.ResponseLIndexPacket;
import com.taobao.tair.extend.packet.list.response.ResponseLLenPacket;
import com.taobao.tair.extend.packet.list.response.ResponseLRPopPacket;
import com.taobao.tair.extend.packet.list.response.ResponseLRPushPacket;
import com.taobao.tair.extend.packet.list.response.ResponseLRangePacket;
import com.taobao.tair.extend.packet.list.response.ResponseLRemPacket;
import com.taobao.tair.extend.packet.list.response.ResponseLTrimPacket;
import com.taobao.tair.extend.packet.set.response.ResponseSAddPacket;
import com.taobao.tair.extend.packet.set.response.ResponseSCardPacket;
import com.taobao.tair.extend.packet.set.response.ResponseSMembersPacket;
import com.taobao.tair.extend.packet.set.response.ResponseSPopPacket;
import com.taobao.tair.extend.packet.zet.response.ResponseZAddPacket;
import com.taobao.tair.extend.packet.zet.response.ResponseZCardPacket;
import com.taobao.tair.extend.packet.zet.response.ResponseZCountPacket;
import com.taobao.tair.extend.packet.zet.response.ResponseZIncrbyPacket;
import com.taobao.tair.extend.packet.zet.response.ResponseZRangePacket;
import com.taobao.tair.extend.packet.zet.response.ResponseZRangebyscorePacket;
import com.taobao.tair.extend.packet.zet.response.ResponseZRankPacket;
import com.taobao.tair.extend.packet.zet.response.ResponseZRemPacket;
import com.taobao.tair.extend.packet.zet.response.ResponseZRemrangebyrankPacket;
import com.taobao.tair.extend.packet.zet.response.ResponseZRemrangebyscorePacket;
import com.taobao.tair.extend.packet.zet.response.ResponseZRevrangePacket;
import com.taobao.tair.extend.packet.zet.response.ResponseZRevrankPacket;
import com.taobao.tair.extend.packet.zet.response.ResponseZScorePacket;
import com.taobao.tair.packet.BasePacket;
import com.taobao.tair.packet.PacketStreamer;
import com.taobao.tair.packet.ResponseGetGroupPacket;
import com.taobao.tair.packet.ResponseGetItemsPacket;
import com.taobao.tair.packet.ResponseGetPacket;
import com.taobao.tair.packet.ResponseIncDecPacket;
import com.taobao.tair.packet.ResponseQueryInfoPacket;
import com.taobao.tair.packet.ReturnPacket;
import java.nio.ByteBuffer;

public class TairPacketStreamer
implements PacketStreamer {
    private Transcoder transcoder = null;

    public TairPacketStreamer(Transcoder transcoder) {
        this.transcoder = transcoder;
    }

    @Override
    public BasePacket decodePacket(int pcode, byte[] data) {
        BasePacket packet = this.createPacket(pcode);
        if (packet != null) {
            packet.setLen(data.length);
            packet.setByteBuffer(ByteBuffer.wrap(data));
        }
        return packet;
    }

    private BasePacket createPacket(int pcode) {
        BasePacket packet = null;
        switch (pcode) {
            case 101: {
                packet = new ReturnPacket(this.transcoder);
                break;
            }
            case 102: {
                packet = new ResponseGetPacket(this.transcoder);
                break;
            }
            case 105: {
                packet = new ResponseIncDecPacket(this.transcoder);
                break;
            }
            case 1102: {
                packet = new ResponseGetGroupPacket(null);
                break;
            }
            case 1405: {
                packet = new ResponseGetItemsPacket(this.transcoder);
                break;
            }
            case 1106: {
                packet = new ResponseQueryInfoPacket(this.transcoder);
                break;
            }
            case 2234: {
                packet = new ResponseTTLPacket(this.transcoder);
                break;
            }
            case 2235: {
                packet = new ResponseTypePacket(this.transcoder);
                break;
            }
            case 2227: {
                packet = new ResponseExpirePacket(this.transcoder);
                break;
            }
            case 2200: {
                packet = new ResponseLRPopPacket(this.transcoder, LeftOrRight.IS_L);
                break;
            }
            case 2201: {
                packet = new ResponseLRPushPacket(this.transcoder, LeftOrRight.IS_L);
                break;
            }
            case 2202: {
                packet = new ResponseLRPopPacket(this.transcoder, LeftOrRight.IS_R);
                break;
            }
            case 2203: {
                packet = new ResponseLRPushPacket(this.transcoder, LeftOrRight.IS_R);
                break;
            }
            case 2206: {
                packet = new ResponseLIndexPacket(this.transcoder);
                break;
            }
            case 2233: {
                packet = new ResponseLLenPacket(this.transcoder);
                break;
            }
            case 2230: {
                packet = new ResponseLRangePacket(this.transcoder);
                break;
            }
            case 2229: {
                packet = new ResponseLRemPacket(this.transcoder);
                break;
            }
            case 2228: {
                packet = new ResponseLTrimPacket(this.transcoder);
                break;
            }
            case 2215: {
                packet = new ResponseHDelPacket(this.transcoder);
                break;
            }
            case 2207: {
                packet = new ResponseHGetallPacket(this.transcoder);
                break;
            }
            case 2212: {
                packet = new ResponseHGetPacket(this.transcoder);
                break;
            }
            case 2208: {
                packet = new ResponseHIncrbyPacket(this.transcoder);
                break;
            }
            case 2213: {
                packet = new ResponseHMgetPacket(this.transcoder);
                break;
            }
            case 2209: {
                packet = new ResponseHMsetPacket(this.transcoder);
                break;
            }
            case 2210: {
                packet = new ResponseHSetPacket(this.transcoder);
                break;
            }
            case 2214: {
                packet = new ResponseHValsPacket(this.transcoder);
                break;
            }
            case 2236: {
                packet = new ResponseHLenPacket(this.transcoder);
                break;
            }
            case 2218: {
                packet = new ResponseSAddPacket(this.transcoder);
                break;
            }
            case 2216: {
                packet = new ResponseSCardPacket(this.transcoder);
                break;
            }
            case 2217: {
                packet = new ResponseSMembersPacket(this.transcoder);
                break;
            }
            case 2219: {
                packet = new ResponseSPopPacket(this.transcoder);
                break;
            }
            case 2224: {
                packet = new ResponseZAddPacket(this.transcoder);
                break;
            }
            case 2226: {
                packet = new ResponseZCardPacket(this.transcoder);
                break;
            }
            case 2223: {
                packet = new ResponseZRangebyscorePacket(this.transcoder);
                break;
            }
            case 2220: {
                packet = new ResponseZRangePacket(this.transcoder);
                break;
            }
            case 2221: {
                packet = new ResponseZRevrangePacket(this.transcoder);
                break;
            }
            case 2225: {
                packet = new ResponseZRankPacket(this.transcoder);
                break;
            }
            case 2222: {
                packet = new ResponseZScorePacket(this.transcoder);
                break;
            }
            case 2237: {
                packet = new ResponseZRemPacket(this.transcoder);
                break;
            }
            case 2238: {
                packet = new ResponseZRemrangebyrankPacket(this.transcoder);
                break;
            }
            case 2239: {
                packet = new ResponseZRemrangebyscorePacket(this.transcoder);
                break;
            }
            case 2240: {
                packet = new ResponseZRevrankPacket(this.transcoder);
                break;
            }
            case 2241: {
                packet = new ResponseZCountPacket(this.transcoder);
                break;
            }
            case 2242: {
                packet = new ResponseZIncrbyPacket(this.transcoder);
                break;
            }
            default: {
                throw new IllegalArgumentException("unkonw return packet, pcode: " + pcode);
            }
        }
        if (packet != null && packet.getPcode() != pcode) {
            packet = null;
        }
        return packet;
    }
}

