/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.controller;

import de.codecentric.boot.admin.event.ClientApplicationEvent;
import de.codecentric.boot.admin.journal.ApplicationEventJournal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@ResponseBody
public class JournalController {
    private static Logger LOGGER = LoggerFactory.getLogger(JournalController.class);
    private ApplicationEventJournal eventJournal;
    private final Collection<SseEmitter> emitters = Collections.synchronizedCollection(new LinkedList());

    public JournalController(ApplicationEventJournal eventJournal) {
        this.eventJournal = eventJournal;
    }

    @RequestMapping(path={"/api/journal"}, produces={"application/json"})
    public Collection<ClientApplicationEvent> getJournal() {
        return this.eventJournal.getEvents();
    }

    @RequestMapping(path={"/api/journal"}, produces={"text/event-stream"})
    public SseEmitter getJournalEvents() {
        final SseEmitter emitter = new SseEmitter();
        emitter.onCompletion(new Runnable(){

            @Override
            public void run() {
                JournalController.this.emitters.remove(emitter);
            }
        });
        this.emitters.add(emitter);
        return emitter;
    }

    @EventListener
    public void onClientApplicationEvent(ClientApplicationEvent event) {
        for (SseEmitter emitter : new ArrayList<SseEmitter>(this.emitters)) {
            try {
                emitter.send((Object)event, MediaType.APPLICATION_JSON);
            }
            catch (Exception ex) {
                LOGGER.debug("Error sending event to client ", (Throwable)ex);
            }
        }
    }
}

