/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.jgitflow.mojo;

import com.atlassian.maven.plugins.jgitflow.ReleaseContext;
import com.atlassian.maven.plugins.jgitflow.exception.MavenJGitFlowException;
import com.atlassian.maven.plugins.jgitflow.manager.FlowReleaseManager;
import com.atlassian.maven.plugins.jgitflow.mojo.AbstractJGitFlowMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="feature-start", aggregator=true)
public class FeatureStartMojo
extends AbstractJGitFlowMojo {
    @Parameter(property="featureName")
    private String featureName;
    @Parameter(defaultValue="false", property="enableFeatureVersions")
    private boolean enableFeatureVersions = false;
    @Parameter(defaultValue="false", property="pushFeatures")
    private boolean pushFeatures = false;
    @Parameter(property="startCommit", defaultValue="")
    private String startCommit = "";
    @Component(hint="feature")
    FlowReleaseManager releaseManager;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ReleaseContext ctx = new ReleaseContext(this.getBasedir());
        ctx.setInteractive(this.getSettings().isInteractiveMode()).setDefaultFeatureName(this.featureName).setEnableFeatureVersions(this.enableFeatureVersions).setEnableSshAgent(this.enableSshAgent).setAllowUntracked(this.allowUntracked).setAllowSnapshots(this.allowSnapshots).setPushFeatures(this.pushFeatures).setStartCommit(this.startCommit).setAllowRemote(this.isRemoteAllowed()).setAlwaysUpdateOrigin(this.alwaysUpdateOrigin).setDefaultOriginUrl(this.defaultOriginUrl).setPullMaster(this.pullMaster).setPullDevelop(this.pullDevelop).setScmCommentPrefix(this.scmCommentPrefix).setScmCommentSuffix(this.scmCommentSuffix).setUseReleaseProfile(false).setUsername(this.username).setPassword(this.password).setEol(this.eol).setFlowInitContext(this.getFlowInitContext().getJGitFlowContext());
        try {
            this.releaseManager.start(ctx, this.getReactorProjects(), this.session);
        }
        catch (MavenJGitFlowException e) {
            throw new MojoExecutionException("Error starting feature: " + e.getMessage(), (Exception)e);
        }
    }
}

