/*
 * Decompiled with CFR 0.152.
 */
package io.seata.config.nacos;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import io.seata.common.exception.NotSupportYetException;
import io.seata.config.AbstractConfiguration;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationFactory;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosConfiguration
extends AbstractConfiguration<Listener> {
    private static volatile NacosConfiguration instance;
    private static final Logger LOGGER;
    private static final String SEATA_GROUP = "SEATA_GROUP";
    private static final String PRO_SERVER_ADDR_KEY = "serverAddr";
    private static final String CONFIG_TYPE = "nacos";
    private static final String DEFAULT_NAMESPACE = "";
    private static final String PRO_NAMESPACE_KEY = "namespace";
    private static final Configuration FILE_CONFIG;
    private static volatile ConfigService configService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NacosConfiguration getInstance() {
        if (null != instance) return instance;
        Class<NacosConfiguration> clazz = NacosConfiguration.class;
        synchronized (NacosConfiguration.class) {
            if (null != instance) return instance;
            instance = new NacosConfiguration();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public NacosConfiguration() {
        if (null == configService) {
            try {
                configService = NacosFactory.createConfigService((Properties)NacosConfiguration.getConfigProperties());
            }
            catch (NacosException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String getConfig(String dataId, String defaultValue, long timeoutMills) {
        String value = this.getConfigFromSysPro(dataId);
        if (value != null) {
            return value;
        }
        try {
            value = configService.getConfig(dataId, SEATA_GROUP, timeoutMills);
        }
        catch (NacosException exx) {
            LOGGER.error(exx.getErrMsg());
        }
        return value == null ? defaultValue : value;
    }

    public boolean putConfig(String dataId, String content, long timeoutMills) {
        boolean result = false;
        try {
            result = configService.publishConfig(dataId, SEATA_GROUP, content);
        }
        catch (NacosException exx) {
            LOGGER.error(exx.getErrMsg());
        }
        return result;
    }

    public boolean putConfigIfAbsent(String dataId, String content, long timeoutMills) {
        throw new NotSupportYetException("not support atomic operation putConfigIfAbsent");
    }

    public boolean removeConfig(String dataId, long timeoutMills) {
        boolean result = false;
        try {
            result = configService.removeConfig(dataId, SEATA_GROUP);
        }
        catch (NacosException exx) {
            LOGGER.error(exx.getErrMsg());
        }
        return result;
    }

    public void addConfigListener(String dataId, Listener listener) {
        try {
            configService.addListener(dataId, SEATA_GROUP, listener);
        }
        catch (NacosException exx) {
            LOGGER.error(exx.getErrMsg());
        }
    }

    public void removeConfigListener(String dataId, Listener listener) {
        configService.removeListener(dataId, SEATA_GROUP, listener);
    }

    public List<Listener> getConfigListeners(String dataId) {
        throw new NotSupportYetException("not support getConfigListeners");
    }

    private static Properties getConfigProperties() {
        Properties properties = new Properties();
        if (null != System.getProperty(PRO_SERVER_ADDR_KEY)) {
            properties.setProperty(PRO_SERVER_ADDR_KEY, System.getProperty(PRO_SERVER_ADDR_KEY));
        } else {
            String address = FILE_CONFIG.getConfig(NacosConfiguration.getNacosAddrFileKey());
            if (null != address) {
                properties.setProperty(PRO_SERVER_ADDR_KEY, address);
            }
        }
        if (null != System.getProperty(PRO_NAMESPACE_KEY)) {
            properties.setProperty(PRO_NAMESPACE_KEY, System.getProperty(PRO_NAMESPACE_KEY));
        } else {
            String namespace = FILE_CONFIG.getConfig(NacosConfiguration.getNacosNameSpaceFileKey());
            if (null == namespace) {
                namespace = DEFAULT_NAMESPACE;
            }
            properties.setProperty(PRO_NAMESPACE_KEY, namespace);
        }
        return properties;
    }

    private static String getNacosNameSpaceFileKey() {
        return "config.nacos.namespace";
    }

    private static String getNacosAddrFileKey() {
        return "config.nacos.serverAddr";
    }

    public String getTypeName() {
        return CONFIG_TYPE;
    }

    static {
        LOGGER = LoggerFactory.getLogger(NacosConfiguration.class);
        FILE_CONFIG = ConfigurationFactory.CURRENT_FILE_INSTANCE;
    }
}

