/*
 * Decompiled with CFR 0.152.
 */
package io.seata.config.nacos;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.AbstractSharedListener;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import io.seata.common.exception.NotSupportYetException;
import io.seata.config.AbstractConfiguration;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationChangeEvent;
import io.seata.config.ConfigurationChangeListener;
import io.seata.config.ConfigurationFactory;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosConfiguration
extends AbstractConfiguration {
    private static volatile NacosConfiguration instance;
    private static final Logger LOGGER;
    private static final String DEFAULT_GROUP = "SEATA_GROUP";
    private static final String GROUP_KEY = "group";
    private static final String PRO_SERVER_ADDR_KEY = "serverAddr";
    private static final String CONFIG_TYPE = "nacos";
    private static final String DEFAULT_NAMESPACE = "";
    private static final String PRO_NAMESPACE_KEY = "namespace";
    private static final Configuration FILE_CONFIG;
    private static volatile ConfigService configService;
    private static final int MAP_INITIAL_CAPACITY = 8;
    private ConcurrentMap<String, ConcurrentMap<ConfigurationChangeListener, NacosListener>> configListenersMap = new ConcurrentHashMap<String, ConcurrentMap<ConfigurationChangeListener, NacosListener>>(8);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NacosConfiguration getInstance() {
        if (null != instance) return instance;
        Class<NacosConfiguration> clazz = NacosConfiguration.class;
        synchronized (NacosConfiguration.class) {
            if (null != instance) return instance;
            instance = new NacosConfiguration();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private NacosConfiguration() {
        if (null == configService) {
            try {
                configService = NacosFactory.createConfigService((Properties)NacosConfiguration.getConfigProperties());
            }
            catch (NacosException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String getConfig(String dataId, String defaultValue, long timeoutMills) {
        String value = this.getConfigFromSysPro(dataId);
        if (value != null) {
            return value;
        }
        try {
            value = configService.getConfig(dataId, NacosConfiguration.getNacosGroup(), timeoutMills);
        }
        catch (NacosException exx) {
            LOGGER.error(exx.getErrMsg());
        }
        return value == null ? defaultValue : value;
    }

    public boolean putConfig(String dataId, String content, long timeoutMills) {
        boolean result = false;
        try {
            result = configService.publishConfig(dataId, NacosConfiguration.getNacosGroup(), content);
        }
        catch (NacosException exx) {
            LOGGER.error(exx.getErrMsg());
        }
        return result;
    }

    public boolean putConfigIfAbsent(String dataId, String content, long timeoutMills) {
        throw new NotSupportYetException("not support atomic operation putConfigIfAbsent");
    }

    public boolean removeConfig(String dataId, long timeoutMills) {
        boolean result = false;
        try {
            result = configService.removeConfig(dataId, NacosConfiguration.getNacosGroup());
        }
        catch (NacosException exx) {
            LOGGER.error(exx.getErrMsg());
        }
        return result;
    }

    public void addConfigListener(String dataId, ConfigurationChangeListener listener) {
        if (null == dataId || null == listener) {
            return;
        }
        try {
            this.configListenersMap.putIfAbsent(dataId, new ConcurrentHashMap());
            NacosListener nacosListener = new NacosListener(dataId, listener);
            ((ConcurrentMap)this.configListenersMap.get(dataId)).put(listener, nacosListener);
            configService.addListener(dataId, NacosConfiguration.getNacosGroup(), (Listener)nacosListener);
        }
        catch (Exception exx) {
            LOGGER.error("add nacos listener error:{}", (Object)exx.getMessage(), (Object)exx);
        }
    }

    public void removeConfigListener(String dataId, ConfigurationChangeListener listener) {
        Set<ConfigurationChangeListener> configChangeListeners = this.getConfigListeners(dataId);
        if (configChangeListeners == null || listener == null) {
            return;
        }
        for (ConfigurationChangeListener entry : configChangeListeners) {
            if (!listener.equals(entry)) continue;
            NacosListener nacosListener = null;
            if (this.configListenersMap.containsKey(dataId)) {
                nacosListener = (NacosListener)((Object)((ConcurrentMap)this.configListenersMap.get(dataId)).get(listener));
                ((ConcurrentMap)this.configListenersMap.get(dataId)).remove(entry);
            }
            if (null == nacosListener) break;
            configService.removeListener(dataId, NacosConfiguration.getNacosGroup(), nacosListener);
            break;
        }
    }

    public Set<ConfigurationChangeListener> getConfigListeners(String dataId) {
        if (this.configListenersMap.containsKey(dataId)) {
            return ((ConcurrentMap)this.configListenersMap.get(dataId)).keySet();
        }
        return null;
    }

    private static Properties getConfigProperties() {
        Properties properties = new Properties();
        if (null != System.getProperty(PRO_SERVER_ADDR_KEY)) {
            properties.setProperty(PRO_SERVER_ADDR_KEY, System.getProperty(PRO_SERVER_ADDR_KEY));
        } else {
            String address = FILE_CONFIG.getConfig(NacosConfiguration.getNacosAddrFileKey());
            if (null != address) {
                properties.setProperty(PRO_SERVER_ADDR_KEY, address);
            }
        }
        if (null != System.getProperty(PRO_NAMESPACE_KEY)) {
            properties.setProperty(PRO_NAMESPACE_KEY, System.getProperty(PRO_NAMESPACE_KEY));
        } else {
            String namespace = FILE_CONFIG.getConfig(NacosConfiguration.getNacosNameSpaceFileKey());
            if (null == namespace) {
                namespace = DEFAULT_NAMESPACE;
            }
            properties.setProperty(PRO_NAMESPACE_KEY, namespace);
        }
        return properties;
    }

    private static String getNacosNameSpaceFileKey() {
        return String.join((CharSequence)".", "config", CONFIG_TYPE, PRO_NAMESPACE_KEY);
    }

    private static String getNacosAddrFileKey() {
        return String.join((CharSequence)".", "config", CONFIG_TYPE, PRO_SERVER_ADDR_KEY);
    }

    private static String getNacosGroupKey() {
        return String.join((CharSequence)".", "config", CONFIG_TYPE, GROUP_KEY);
    }

    private static String getNacosGroup() {
        return FILE_CONFIG.getConfig(NacosConfiguration.getNacosGroupKey(), DEFAULT_GROUP);
    }

    public String getTypeName() {
        return CONFIG_TYPE;
    }

    static {
        LOGGER = LoggerFactory.getLogger(NacosConfiguration.class);
        FILE_CONFIG = ConfigurationFactory.CURRENT_FILE_INSTANCE;
    }

    public static class NacosListener
    extends AbstractSharedListener {
        private final String dataId;
        private final ConfigurationChangeListener listener;

        public NacosListener(String dataId, ConfigurationChangeListener listener) {
            this.dataId = dataId;
            this.listener = listener;
        }

        public ConfigurationChangeListener getTargetListener() {
            return this.listener;
        }

        public void innerReceive(String dataId, String group, String configInfo) {
            ConfigurationChangeEvent event = new ConfigurationChangeEvent().setDataId(dataId).setNewValue(configInfo).setNamespace(group);
            this.listener.onProcessEvent(event);
        }
    }
}

