/*
 * Decompiled with CFR 0.152.
 */
package io.seata.metrics.exporter;

import io.seata.common.loader.EnhancedServiceLoader;
import io.seata.common.util.StringUtils;
import io.seata.config.ConfigurationFactory;
import io.seata.metrics.exporter.Exporter;
import io.seata.metrics.exporter.ExporterType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExporterFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExporterFactory.class);

    public static List<Exporter> getInstanceList() {
        ArrayList<Exporter> exporters = new ArrayList<Exporter>();
        String exporterTypeNameList = ConfigurationFactory.getInstance().getConfig("metrics.exporterList", null);
        if (!StringUtils.isNullOrEmpty((String)exporterTypeNameList)) {
            String[] exporterTypeNames;
            for (String exporterTypeName : exporterTypeNames = exporterTypeNameList.split(",")) {
                try {
                    ExporterType exporterType = ExporterType.getType(exporterTypeName);
                    exporters.add((Exporter)EnhancedServiceLoader.load(Exporter.class, (String)Objects.requireNonNull(exporterType).name()));
                }
                catch (Exception exx) {
                    LOGGER.error("not support metrics exporter type: {}", (Object)exporterTypeName, (Object)exx);
                }
            }
        }
        return exporters;
    }
}

