/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.jdbc.exceptions;

import com.mysql.cj.api.MysqlConnection;
import com.mysql.cj.api.exceptions.ExceptionInterceptor;
import com.mysql.cj.api.jdbc.JdbcConnection;
import com.mysql.cj.core.Messages;
import com.mysql.cj.core.exceptions.MysqlErrorNumbers;
import com.mysql.cj.core.util.Util;
import com.mysql.cj.jdbc.exceptions.CommunicationsException;
import com.mysql.cj.jdbc.exceptions.MySQLQueryInterruptedException;
import com.mysql.cj.jdbc.exceptions.MySQLTransactionRollbackException;
import com.mysql.cj.jdbc.exceptions.NotUpdatable;
import java.lang.reflect.Field;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLTransientConnectionException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class SQLError {
    public static final int ER_WARNING_NOT_COMPLETE_ROLLBACK = 1196;
    public static final String SQL_STATE_BAD_SSL_PARAMS = "08000";
    private static Map<Integer, String> mysqlToSql99State;
    public static final String SQL_STATE_WARNING = "01000";
    public static final String SQL_STATE_DISCONNECT_ERROR = "01002";
    public static final String SQL_STATE_DATE_TRUNCATED = "01004";
    public static final String SQL_STATE_PRIVILEGE_NOT_REVOKED = "01006";
    public static final String SQL_STATE_NO_DATA = "02000";
    public static final String SQL_STATE_WRONG_NO_OF_PARAMETERS = "07001";
    public static final String SQL_STATE_UNABLE_TO_CONNECT_TO_DATASOURCE = "08001";
    public static final String SQL_STATE_CONNECTION_IN_USE = "08002";
    public static final String SQL_STATE_CONNECTION_NOT_OPEN = "08003";
    public static final String SQL_STATE_CONNECTION_REJECTED = "08004";
    public static final String SQL_STATE_CONNECTION_FAILURE = "08006";
    public static final String SQL_STATE_TRANSACTION_RESOLUTION_UNKNOWN = "08007";
    public static final String SQL_STATE_COMMUNICATION_LINK_FAILURE = "08S01";
    public static final String SQL_STATE_FEATURE_NOT_SUPPORTED = "0A000";
    public static final String SQL_STATE_CARDINALITY_VIOLATION = "21000";
    public static final String SQL_STATE_INSERT_VALUE_LIST_NO_MATCH_COL_LIST = "21S01";
    public static final String SQL_STATE_STRING_DATA_RIGHT_TRUNCATION = "22001";
    public static final String SQL_STATE_NUMERIC_VALUE_OUT_OF_RANGE = "22003";
    public static final String SQL_STATE_INVALID_DATETIME_FORMAT = "22007";
    public static final String SQL_STATE_DATETIME_FIELD_OVERFLOW = "22008";
    public static final String SQL_STATE_DIVISION_BY_ZERO = "22012";
    public static final String SQL_STATE_INVALID_CHARACTER_VALUE_FOR_CAST = "22018";
    public static final String SQL_STATE_INTEGRITY_CONSTRAINT_VIOLATION = "23000";
    public static final String SQL_STATE_INVALID_CURSOR_STATE = "24000";
    public static final String SQL_STATE_INVALID_TRANSACTION_STATE = "25000";
    public static final String SQL_STATE_INVALID_AUTH_SPEC = "28000";
    public static final String SQL_STATE_INVALID_TRANSACTION_TERMINATION = "2D000";
    public static final String SQL_STATE_INVALID_CONDITION_NUMBER = "35000";
    public static final String SQL_STATE_INVALID_CATALOG_NAME = "3D000";
    public static final String SQL_STATE_ROLLBACK_SERIALIZATION_FAILURE = "40001";
    public static final String SQL_STATE_SYNTAX_ERROR = "42000";
    public static final String SQL_STATE_ER_TABLE_EXISTS_ERROR = "42S01";
    public static final String SQL_STATE_BASE_TABLE_OR_VIEW_NOT_FOUND = "42S02";
    public static final String SQL_STATE_ER_NO_SUCH_INDEX = "42S12";
    public static final String SQL_STATE_ER_DUP_FIELDNAME = "42S21";
    public static final String SQL_STATE_ER_BAD_FIELD_ERROR = "42S22";
    public static final String SQL_STATE_INVALID_CONNECTION_ATTRIBUTE = "01S00";
    public static final String SQL_STATE_ERROR_IN_ROW = "01S01";
    public static final String SQL_STATE_NO_ROWS_UPDATED_OR_DELETED = "01S03";
    public static final String SQL_STATE_MORE_THAN_ONE_ROW_UPDATED_OR_DELETED = "01S04";
    public static final String SQL_STATE_RESIGNAL_WHEN_HANDLER_NOT_ACTIVE = "0K000";
    public static final String SQL_STATE_STACKED_DIAGNOSTICS_ACCESSED_WITHOUT_ACTIVE_HANDLER = "0Z002";
    public static final String SQL_STATE_CASE_NOT_FOUND_FOR_CASE_STATEMENT = "20000";
    public static final String SQL_STATE_NULL_VALUE_NOT_ALLOWED = "22004";
    public static final String SQL_STATE_INVALID_LOGARITHM_ARGUMENT = "2201E";
    public static final String SQL_STATE_ACTIVE_SQL_TRANSACTION = "25001";
    public static final String SQL_STATE_READ_ONLY_SQL_TRANSACTION = "25006";
    public static final String SQL_STATE_SRE_PROHIBITED_SQL_STATEMENT_ATTEMPTED = "2F003";
    public static final String SQL_STATE_SRE_FUNCTION_EXECUTED_NO_RETURN_STATEMENT = "2F005";
    public static final String SQL_STATE_ER_QUERY_INTERRUPTED = "70100";
    public static final String SQL_STATE_BASE_TABLE_OR_VIEW_ALREADY_EXISTS = "S0001";
    public static final String SQL_STATE_BASE_TABLE_NOT_FOUND = "S0002";
    public static final String SQL_STATE_INDEX_ALREADY_EXISTS = "S0011";
    public static final String SQL_STATE_INDEX_NOT_FOUND = "S0012";
    public static final String SQL_STATE_COLUMN_ALREADY_EXISTS = "S0021";
    public static final String SQL_STATE_COLUMN_NOT_FOUND = "S0022";
    public static final String SQL_STATE_NO_DEFAULT_FOR_COLUMN = "S0023";
    public static final String SQL_STATE_GENERAL_ERROR = "S1000";
    public static final String SQL_STATE_MEMORY_ALLOCATION_FAILURE = "S1001";
    public static final String SQL_STATE_INVALID_COLUMN_NUMBER = "S1002";
    public static final String SQL_STATE_ILLEGAL_ARGUMENT = "S1009";
    public static final String SQL_STATE_DRIVER_NOT_CAPABLE = "S1C00";
    public static final String SQL_STATE_TIMEOUT_EXPIRED = "S1T00";
    public static final String SQL_STATE_CLI_SPECIFIC_CONDITION = "HY000";
    public static final String SQL_STATE_MEMORY_ALLOCATION_ERROR = "HY001";
    public static final String SQL_STATE_XA_RBROLLBACK = "XA100";
    public static final String SQL_STATE_XA_RBDEADLOCK = "XA102";
    public static final String SQL_STATE_XA_RBTIMEOUT = "XA106";
    public static final String SQL_STATE_XA_RMERR = "XAE03";
    public static final String SQL_STATE_XAER_NOTA = "XAE04";
    public static final String SQL_STATE_XAER_INVAL = "XAE05";
    public static final String SQL_STATE_XAER_RMFAIL = "XAE07";
    public static final String SQL_STATE_XAER_DUPID = "XAE08";
    public static final String SQL_STATE_XAER_OUTSIDE = "XAE09";
    private static Map<String, String> sqlStateMessages;

    public static void dumpSqlStatesMappingsAsXml() throws Exception {
        TreeMap<Integer, Integer> allErrorNumbers = new TreeMap<Integer, Integer>();
        HashMap<Object, String> mysqlErrorNumbersToNames = new HashMap<Object, String>();
        for (Integer errorNumber : mysqlToSql99State.keySet()) {
            allErrorNumbers.put(errorNumber, errorNumber);
        }
        Field[] possibleFields = MysqlErrorNumbers.class.getDeclaredFields();
        for (int i = 0; i < possibleFields.length; ++i) {
            String fieldName = possibleFields[i].getName();
            if (!fieldName.startsWith("ER_")) continue;
            mysqlErrorNumbersToNames.put(possibleFields[i].get(null), fieldName);
        }
        System.out.println("<ErrorMappings>");
        for (Integer errorNumber : allErrorNumbers.keySet()) {
            String sql92State = SQLError.mysqlToSql99(errorNumber);
            System.out.println("   <ErrorMapping mysqlErrorNumber=\"" + errorNumber + "\" mysqlErrorName=\"" + (String)mysqlErrorNumbersToNames.get(errorNumber) + "\" legacySqlState=\"" + "" + "\" sql92SqlState=\"" + (sql92State == null ? "" : sql92State) + "\"/>");
        }
        System.out.println("</ErrorMappings>");
    }

    public static String get(String stateCode) {
        return sqlStateMessages.get(stateCode);
    }

    private static String mysqlToSql99(int errno) {
        Integer err = errno;
        if (mysqlToSql99State.containsKey(err)) {
            return mysqlToSql99State.get(err);
        }
        return SQL_STATE_CLI_SPECIFIC_CONDITION;
    }

    public static String mysqlToSqlState(int errno) {
        return SQLError.mysqlToSql99(errno);
    }

    public static SQLException createSQLException(String message, String sqlState, ExceptionInterceptor interceptor) {
        return SQLError.createSQLException(message, sqlState, 0, interceptor);
    }

    public static SQLException createSQLException(String message, ExceptionInterceptor interceptor) {
        return SQLError.createSQLException(message, interceptor, null);
    }

    public static SQLException createSQLException(String message, ExceptionInterceptor interceptor, JdbcConnection conn) {
        SQLException sqlEx = new SQLException(message);
        return SQLError.runThroughExceptionInterceptor(interceptor, sqlEx, conn);
    }

    public static SQLException createSQLException(String message, String sqlState, Throwable cause, ExceptionInterceptor interceptor) {
        return SQLError.createSQLException(message, sqlState, cause, interceptor, null);
    }

    public static SQLException createSQLException(String message, String sqlState, Throwable cause, ExceptionInterceptor interceptor, MysqlConnection conn) {
        SQLException sqlEx = SQLError.createSQLException(message, sqlState, interceptor);
        if (cause != null) {
            try {
                sqlEx.initCause(cause);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return SQLError.runThroughExceptionInterceptor(interceptor, sqlEx, conn);
    }

    public static SQLException createSQLException(String message, String sqlState, int vendorErrorCode, ExceptionInterceptor interceptor) {
        return SQLError.createSQLException(message, sqlState, vendorErrorCode, false, interceptor);
    }

    public static SQLException createSQLException(String message, String sqlState, int vendorErrorCode, Throwable cause, ExceptionInterceptor interceptor) {
        return SQLError.createSQLException(message, sqlState, vendorErrorCode, false, cause, interceptor);
    }

    public static SQLException createSQLException(String message, String sqlState, int vendorErrorCode, boolean isTransient, ExceptionInterceptor interceptor) {
        return SQLError.createSQLException(message, sqlState, vendorErrorCode, isTransient, interceptor, null);
    }

    public static SQLException createSQLException(String message, String sqlState, int vendorErrorCode, boolean isTransient, Throwable cause, ExceptionInterceptor interceptor) {
        return SQLError.createSQLException(message, sqlState, vendorErrorCode, isTransient, cause, interceptor, null);
    }

    public static SQLException createSQLException(String message, String sqlState, int vendorErrorCode, boolean isTransient, ExceptionInterceptor interceptor, JdbcConnection conn) {
        return SQLError.createSQLException(message, sqlState, vendorErrorCode, isTransient, null, interceptor, conn);
    }

    public static SQLException createSQLException(String message, String sqlState, int vendorErrorCode, boolean isTransient, Throwable cause, ExceptionInterceptor interceptor, JdbcConnection conn) {
        try {
            SQLException sqlEx = null;
            sqlEx = sqlState != null ? (sqlState.startsWith("08") ? (isTransient ? new SQLTransientConnectionException(message, sqlState, vendorErrorCode) : new SQLNonTransientConnectionException(message, sqlState, vendorErrorCode)) : (sqlState.startsWith("22") ? new SQLDataException(message, sqlState, vendorErrorCode) : (sqlState.startsWith("23") ? new SQLIntegrityConstraintViolationException(message, sqlState, vendorErrorCode) : (sqlState.startsWith("42") ? new SQLSyntaxErrorException(message, sqlState, vendorErrorCode) : (sqlState.startsWith("40") ? new MySQLTransactionRollbackException(message, sqlState, vendorErrorCode) : (sqlState.startsWith(SQL_STATE_ER_QUERY_INTERRUPTED) ? new MySQLQueryInterruptedException(message, sqlState, vendorErrorCode) : new SQLException(message, sqlState, vendorErrorCode))))))) : new SQLException(message, sqlState, vendorErrorCode);
            if (cause != null) {
                try {
                    sqlEx.initCause(cause);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return SQLError.runThroughExceptionInterceptor(interceptor, sqlEx, conn);
        }
        catch (Exception sqlEx) {
            SQLException unexpectedEx = new SQLException("Unable to create correct SQLException class instance, error class/codes may be incorrect. Reason: " + Util.stackTraceToString(sqlEx), SQL_STATE_GENERAL_ERROR);
            return SQLError.runThroughExceptionInterceptor(interceptor, unexpectedEx, conn);
        }
    }

    public static SQLException createCommunicationsException(JdbcConnection conn, long lastPacketSentTimeMs, long lastPacketReceivedTimeMs, Exception underlyingException, ExceptionInterceptor interceptor) {
        CommunicationsException exToReturn = new CommunicationsException(conn, lastPacketSentTimeMs, lastPacketReceivedTimeMs, underlyingException);
        if (underlyingException != null) {
            try {
                exToReturn.initCause(underlyingException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return SQLError.runThroughExceptionInterceptor(interceptor, exToReturn, conn);
    }

    public static SQLException createCommunicationsException(JdbcConnection conn, String message, Throwable underlyingException, ExceptionInterceptor interceptor) {
        CommunicationsException exToReturn = null;
        exToReturn = new CommunicationsException(message, underlyingException);
        if (underlyingException != null) {
            try {
                exToReturn.initCause(underlyingException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return SQLError.runThroughExceptionInterceptor(interceptor, exToReturn, conn);
    }

    public static NotUpdatable notUpdatable() {
        return new NotUpdatable();
    }

    private static SQLException runThroughExceptionInterceptor(ExceptionInterceptor exInterceptor, SQLException sqlEx, MysqlConnection conn) {
        SQLException interceptedEx;
        if (exInterceptor != null && (interceptedEx = (SQLException)exInterceptor.interceptException(sqlEx, conn)) != null) {
            return interceptedEx;
        }
        return sqlEx;
    }

    public static SQLException createBatchUpdateException(SQLException underlyingEx, long[] updateCounts, ExceptionInterceptor interceptor) throws SQLException {
        SQLException newEx = (SQLException)Util.getInstance("java.sql.BatchUpdateException", new Class[]{String.class, String.class, Integer.TYPE, long[].class, Throwable.class}, new Object[]{underlyingEx.getMessage(), underlyingEx.getSQLState(), underlyingEx.getErrorCode(), updateCounts, underlyingEx}, interceptor);
        return SQLError.runThroughExceptionInterceptor(interceptor, newEx, null);
    }

    public static SQLException createSQLFeatureNotSupportedException() {
        return new SQLFeatureNotSupportedException();
    }

    public static SQLException createSQLFeatureNotSupportedException(String message, String sqlState, ExceptionInterceptor interceptor) throws SQLException {
        SQLFeatureNotSupportedException newEx = new SQLFeatureNotSupportedException(message, sqlState);
        return SQLError.runThroughExceptionInterceptor(interceptor, newEx, null);
    }

    static {
        sqlStateMessages = new HashMap<String, String>();
        sqlStateMessages.put(SQL_STATE_DISCONNECT_ERROR, Messages.getString("SQLError.35"));
        sqlStateMessages.put(SQL_STATE_DATE_TRUNCATED, Messages.getString("SQLError.36"));
        sqlStateMessages.put(SQL_STATE_PRIVILEGE_NOT_REVOKED, Messages.getString("SQLError.37"));
        sqlStateMessages.put(SQL_STATE_INVALID_CONNECTION_ATTRIBUTE, Messages.getString("SQLError.38"));
        sqlStateMessages.put(SQL_STATE_ERROR_IN_ROW, Messages.getString("SQLError.39"));
        sqlStateMessages.put(SQL_STATE_NO_ROWS_UPDATED_OR_DELETED, Messages.getString("SQLError.40"));
        sqlStateMessages.put(SQL_STATE_MORE_THAN_ONE_ROW_UPDATED_OR_DELETED, Messages.getString("SQLError.41"));
        sqlStateMessages.put(SQL_STATE_WRONG_NO_OF_PARAMETERS, Messages.getString("SQLError.42"));
        sqlStateMessages.put(SQL_STATE_UNABLE_TO_CONNECT_TO_DATASOURCE, Messages.getString("SQLError.43"));
        sqlStateMessages.put(SQL_STATE_CONNECTION_IN_USE, Messages.getString("SQLError.44"));
        sqlStateMessages.put(SQL_STATE_CONNECTION_NOT_OPEN, Messages.getString("SQLError.45"));
        sqlStateMessages.put(SQL_STATE_CONNECTION_REJECTED, Messages.getString("SQLError.46"));
        sqlStateMessages.put(SQL_STATE_TRANSACTION_RESOLUTION_UNKNOWN, Messages.getString("SQLError.47"));
        sqlStateMessages.put(SQL_STATE_COMMUNICATION_LINK_FAILURE, Messages.getString("SQLError.48"));
        sqlStateMessages.put(SQL_STATE_INSERT_VALUE_LIST_NO_MATCH_COL_LIST, Messages.getString("SQLError.49"));
        sqlStateMessages.put(SQL_STATE_NUMERIC_VALUE_OUT_OF_RANGE, Messages.getString("SQLError.50"));
        sqlStateMessages.put(SQL_STATE_DATETIME_FIELD_OVERFLOW, Messages.getString("SQLError.51"));
        sqlStateMessages.put(SQL_STATE_DIVISION_BY_ZERO, Messages.getString("SQLError.52"));
        sqlStateMessages.put(SQL_STATE_ROLLBACK_SERIALIZATION_FAILURE, Messages.getString("SQLError.53"));
        sqlStateMessages.put(SQL_STATE_INVALID_AUTH_SPEC, Messages.getString("SQLError.54"));
        sqlStateMessages.put(SQL_STATE_SYNTAX_ERROR, Messages.getString("SQLError.55"));
        sqlStateMessages.put(SQL_STATE_BASE_TABLE_OR_VIEW_NOT_FOUND, Messages.getString("SQLError.56"));
        sqlStateMessages.put(SQL_STATE_BASE_TABLE_OR_VIEW_ALREADY_EXISTS, Messages.getString("SQLError.57"));
        sqlStateMessages.put(SQL_STATE_BASE_TABLE_NOT_FOUND, Messages.getString("SQLError.58"));
        sqlStateMessages.put(SQL_STATE_INDEX_ALREADY_EXISTS, Messages.getString("SQLError.59"));
        sqlStateMessages.put(SQL_STATE_INDEX_NOT_FOUND, Messages.getString("SQLError.60"));
        sqlStateMessages.put(SQL_STATE_COLUMN_ALREADY_EXISTS, Messages.getString("SQLError.61"));
        sqlStateMessages.put(SQL_STATE_COLUMN_NOT_FOUND, Messages.getString("SQLError.62"));
        sqlStateMessages.put(SQL_STATE_NO_DEFAULT_FOR_COLUMN, Messages.getString("SQLError.63"));
        sqlStateMessages.put(SQL_STATE_GENERAL_ERROR, Messages.getString("SQLError.64"));
        sqlStateMessages.put(SQL_STATE_MEMORY_ALLOCATION_FAILURE, Messages.getString("SQLError.65"));
        sqlStateMessages.put(SQL_STATE_INVALID_COLUMN_NUMBER, Messages.getString("SQLError.66"));
        sqlStateMessages.put(SQL_STATE_ILLEGAL_ARGUMENT, Messages.getString("SQLError.67"));
        sqlStateMessages.put(SQL_STATE_DRIVER_NOT_CAPABLE, Messages.getString("SQLError.68"));
        sqlStateMessages.put(SQL_STATE_TIMEOUT_EXPIRED, Messages.getString("SQLError.69"));
        mysqlToSql99State = new HashMap<Integer, String>();
        mysqlToSql99State.put(1249, SQL_STATE_WARNING);
        mysqlToSql99State.put(1261, SQL_STATE_WARNING);
        mysqlToSql99State.put(1262, SQL_STATE_WARNING);
        mysqlToSql99State.put(1265, SQL_STATE_WARNING);
        mysqlToSql99State.put(1263, SQL_STATE_NULL_VALUE_NOT_ALLOWED);
        mysqlToSql99State.put(1264, SQL_STATE_NUMERIC_VALUE_OUT_OF_RANGE);
        mysqlToSql99State.put(1311, SQL_STATE_WARNING);
        mysqlToSql99State.put(1642, SQL_STATE_WARNING);
        mysqlToSql99State.put(1329, SQL_STATE_NO_DATA);
        mysqlToSql99State.put(1643, SQL_STATE_NO_DATA);
        mysqlToSql99State.put(1040, SQL_STATE_CONNECTION_REJECTED);
        mysqlToSql99State.put(1251, SQL_STATE_CONNECTION_REJECTED);
        mysqlToSql99State.put(1042, SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSql99State.put(1043, SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSql99State.put(1047, SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSql99State.put(1053, SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSql99State.put(1080, SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSql99State.put(1081, SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSql99State.put(1152, SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSql99State.put(1153, SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSql99State.put(1154, SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSql99State.put(1155, SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSql99State.put(1156, SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSql99State.put(1157, SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSql99State.put(1158, SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSql99State.put(1159, SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSql99State.put(1160, SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSql99State.put(1161, SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSql99State.put(1184, SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSql99State.put(1189, SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSql99State.put(1190, SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSql99State.put(1218, SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSql99State.put(1312, SQL_STATE_FEATURE_NOT_SUPPORTED);
        mysqlToSql99State.put(1314, SQL_STATE_FEATURE_NOT_SUPPORTED);
        mysqlToSql99State.put(1335, SQL_STATE_FEATURE_NOT_SUPPORTED);
        mysqlToSql99State.put(1336, SQL_STATE_FEATURE_NOT_SUPPORTED);
        mysqlToSql99State.put(1415, SQL_STATE_FEATURE_NOT_SUPPORTED);
        mysqlToSql99State.put(1845, SQL_STATE_FEATURE_NOT_SUPPORTED);
        mysqlToSql99State.put(1846, SQL_STATE_FEATURE_NOT_SUPPORTED);
        mysqlToSql99State.put(1044, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1049, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1055, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1056, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1057, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1059, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1061, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1063, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1064, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1065, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1066, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1067, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1068, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1069, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1070, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1071, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1072, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1073, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1074, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1075, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1083, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1084, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1090, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1091, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1101, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1102, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1103, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1104, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1106, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1107, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1110, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1112, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1113, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1115, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1118, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1120, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1121, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1131, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1132, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1133, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1139, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1140, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1141, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1142, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1143, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1144, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1145, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1147, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1148, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1149, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1162, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1163, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1164, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1166, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1167, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1170, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1171, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1172, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1173, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1176, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1177, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1178, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1203, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1211, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1226, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1227, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1230, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1231, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1232, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1234, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1235, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1239, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1248, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1250, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1252, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1253, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1280, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1281, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1286, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1304, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1305, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1308, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1309, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1310, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1313, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1315, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1316, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1318, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1319, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1320, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1322, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1323, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1324, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1327, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1330, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1331, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1332, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1333, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1337, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1338, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1370, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1403, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1407, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1410, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1413, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1414, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1425, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1426, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1427, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1437, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1439, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1453, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1458, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1460, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1461, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1463, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1582, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1583, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1584, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1630, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1641, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1687, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1701, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1222, SQL_STATE_CARDINALITY_VIOLATION);
        mysqlToSql99State.put(1241, SQL_STATE_CARDINALITY_VIOLATION);
        mysqlToSql99State.put(1242, SQL_STATE_CARDINALITY_VIOLATION);
        mysqlToSql99State.put(1022, SQL_STATE_INTEGRITY_CONSTRAINT_VIOLATION);
        mysqlToSql99State.put(1048, SQL_STATE_INTEGRITY_CONSTRAINT_VIOLATION);
        mysqlToSql99State.put(1052, SQL_STATE_INTEGRITY_CONSTRAINT_VIOLATION);
        mysqlToSql99State.put(1062, SQL_STATE_INTEGRITY_CONSTRAINT_VIOLATION);
        mysqlToSql99State.put(1169, SQL_STATE_INTEGRITY_CONSTRAINT_VIOLATION);
        mysqlToSql99State.put(1216, SQL_STATE_INTEGRITY_CONSTRAINT_VIOLATION);
        mysqlToSql99State.put(1217, SQL_STATE_INTEGRITY_CONSTRAINT_VIOLATION);
        mysqlToSql99State.put(1451, SQL_STATE_INTEGRITY_CONSTRAINT_VIOLATION);
        mysqlToSql99State.put(1452, SQL_STATE_INTEGRITY_CONSTRAINT_VIOLATION);
        mysqlToSql99State.put(1557, SQL_STATE_INTEGRITY_CONSTRAINT_VIOLATION);
        mysqlToSql99State.put(1586, SQL_STATE_INTEGRITY_CONSTRAINT_VIOLATION);
        mysqlToSql99State.put(1761, SQL_STATE_INTEGRITY_CONSTRAINT_VIOLATION);
        mysqlToSql99State.put(1762, SQL_STATE_INTEGRITY_CONSTRAINT_VIOLATION);
        mysqlToSql99State.put(1859, SQL_STATE_INTEGRITY_CONSTRAINT_VIOLATION);
        mysqlToSql99State.put(1406, SQL_STATE_STRING_DATA_RIGHT_TRUNCATION);
        mysqlToSql99State.put(1416, SQL_STATE_NUMERIC_VALUE_OUT_OF_RANGE);
        mysqlToSql99State.put(1690, SQL_STATE_NUMERIC_VALUE_OUT_OF_RANGE);
        mysqlToSql99State.put(1292, SQL_STATE_INVALID_DATETIME_FORMAT);
        mysqlToSql99State.put(1367, SQL_STATE_INVALID_DATETIME_FORMAT);
        mysqlToSql99State.put(1441, SQL_STATE_DATETIME_FIELD_OVERFLOW);
        mysqlToSql99State.put(1365, SQL_STATE_DIVISION_BY_ZERO);
        mysqlToSql99State.put(1325, SQL_STATE_INVALID_CURSOR_STATE);
        mysqlToSql99State.put(1326, SQL_STATE_INVALID_CURSOR_STATE);
        mysqlToSql99State.put(1179, SQL_STATE_INVALID_TRANSACTION_STATE);
        mysqlToSql99State.put(1207, SQL_STATE_INVALID_TRANSACTION_STATE);
        mysqlToSql99State.put(1045, SQL_STATE_INVALID_AUTH_SPEC);
        mysqlToSql99State.put(1698, SQL_STATE_INVALID_AUTH_SPEC);
        mysqlToSql99State.put(1873, SQL_STATE_INVALID_AUTH_SPEC);
        mysqlToSql99State.put(1758, SQL_STATE_INVALID_CONDITION_NUMBER);
        mysqlToSql99State.put(1046, SQL_STATE_INVALID_CATALOG_NAME);
        mysqlToSql99State.put(1645, SQL_STATE_RESIGNAL_WHEN_HANDLER_NOT_ACTIVE);
        mysqlToSql99State.put(1887, SQL_STATE_STACKED_DIAGNOSTICS_ACCESSED_WITHOUT_ACTIVE_HANDLER);
        mysqlToSql99State.put(1339, SQL_STATE_CASE_NOT_FOUND_FOR_CASE_STATEMENT);
        mysqlToSql99State.put(1058, SQL_STATE_INSERT_VALUE_LIST_NO_MATCH_COL_LIST);
        mysqlToSql99State.put(1136, SQL_STATE_INSERT_VALUE_LIST_NO_MATCH_COL_LIST);
        mysqlToSql99State.put(1138, SQL_STATE_NULL_VALUE_NOT_ALLOWED);
        mysqlToSql99State.put(1903, SQL_STATE_INVALID_LOGARITHM_ARGUMENT);
        mysqlToSql99State.put(1568, SQL_STATE_ACTIVE_SQL_TRANSACTION);
        mysqlToSql99State.put(1792, SQL_STATE_READ_ONLY_SQL_TRANSACTION);
        mysqlToSql99State.put(1303, SQL_STATE_SRE_PROHIBITED_SQL_STATEMENT_ATTEMPTED);
        mysqlToSql99State.put(1321, SQL_STATE_SRE_FUNCTION_EXECUTED_NO_RETURN_STATEMENT);
        mysqlToSql99State.put(1050, SQL_STATE_ER_TABLE_EXISTS_ERROR);
        mysqlToSql99State.put(1051, SQL_STATE_BASE_TABLE_OR_VIEW_NOT_FOUND);
        mysqlToSql99State.put(1109, SQL_STATE_BASE_TABLE_OR_VIEW_NOT_FOUND);
        mysqlToSql99State.put(1146, SQL_STATE_BASE_TABLE_OR_VIEW_NOT_FOUND);
        mysqlToSql99State.put(1082, SQL_STATE_ER_NO_SUCH_INDEX);
        mysqlToSql99State.put(1060, SQL_STATE_ER_DUP_FIELDNAME);
        mysqlToSql99State.put(1054, SQL_STATE_ER_BAD_FIELD_ERROR);
        mysqlToSql99State.put(1247, SQL_STATE_ER_BAD_FIELD_ERROR);
        mysqlToSql99State.put(1317, SQL_STATE_ER_QUERY_INTERRUPTED);
        mysqlToSql99State.put(1037, SQL_STATE_MEMORY_ALLOCATION_ERROR);
        mysqlToSql99State.put(1038, SQL_STATE_MEMORY_ALLOCATION_ERROR);
        mysqlToSql99State.put(1402, SQL_STATE_XA_RBROLLBACK);
        mysqlToSql99State.put(1614, SQL_STATE_XA_RBDEADLOCK);
        mysqlToSql99State.put(1613, SQL_STATE_XA_RBTIMEOUT);
        mysqlToSql99State.put(1401, SQL_STATE_XA_RMERR);
        mysqlToSql99State.put(1397, SQL_STATE_XAER_NOTA);
        mysqlToSql99State.put(1398, SQL_STATE_XAER_INVAL);
        mysqlToSql99State.put(1399, SQL_STATE_XAER_RMFAIL);
        mysqlToSql99State.put(1440, SQL_STATE_XAER_DUPID);
        mysqlToSql99State.put(1400, SQL_STATE_XAER_OUTSIDE);
        mysqlToSql99State.put(1205, SQL_STATE_ROLLBACK_SERIALIZATION_FAILURE);
        mysqlToSql99State.put(1213, SQL_STATE_ROLLBACK_SERIALIZATION_FAILURE);
    }
}

