/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.base.util;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.BadSqlGrammarException;

public class SqlInjectionUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SqlInjectionUtil.class);
    private static final String XSS_STR = "'|and |exec |insert |select |delete |update |drop |count |chr |mid |master |truncate |char |declare |;|or |+|,";
    private static final String REG = "(?:')|(?:--)|(/\\*(?:.|[\\n\\r])*?\\*/)| (\\b(select |update |and |or |delete |insert |trancate |char| into |substr |ascii |declare |exec |count |master|drop |execute )\\b)";
    private static final Pattern sqlPattern = Pattern.compile("(?:')|(?:--)|(/\\*(?:.|[\\n\\r])*?\\*/)| (\\b(select |update |and |or |delete |insert |trancate |char| into |substr |ascii |declare |exec |count |master|drop |execute )\\b)", 2);

    public static void filterContent(String ... values) {
        String[] xssArr = XSS_STR.split("\\|");
        for (String value : values) {
            if (value == null || "".equals(value)) continue;
            value = value.toLowerCase();
            for (int i = 0; i < xssArr.length; ++i) {
                if (value.indexOf(xssArr[i]) <= -1) continue;
                LOG.info("\u8bf7\u6ce8\u610f\uff0c\u5b58\u5728SQL\u6ce8\u5165\u5173\u952e\u8bcd---> {}", (Object)xssArr[i]);
                LOG.info("\u8bf7\u6ce8\u610f\uff0c\u503c\u53ef\u80fd\u5b58\u5728SQL\u6ce8\u5165\u98ce\u9669!---> {}", (Object)value);
                throw new BadSqlGrammarException("", "bad sql" + value, new SQLException("\u5f53\u524d\u64cd\u4f5c\u5b58\u5728SQL\u975e\u6cd5\u6ce8\u5165"));
            }
        }
    }

    public static void filterContent(Map<String, String> fields) {
        Iterator<String> iterator = fields.keySet().iterator();
        while (iterator.hasNext()) {
            String key = iterator.next().toString();
            String value = fields.get(key);
            SqlInjectionUtil.filterContent(key);
            SqlInjectionUtil.filterContent(value);
        }
    }

    public static boolean isSqlValid(String str) {
        Matcher matcher = sqlPattern.matcher(str);
        if (matcher.find() && StringUtils.isNotBlank((CharSequence)matcher.group())) {
            LOG.info("\u53c2\u6570\u5b58\u5728\u975e\u6cd5\u5b57\u7b26\uff0c\u8bf7\u786e\u8ba4\uff1a" + matcher.group());
            return false;
        }
        return true;
    }
}

