/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.mdiy.util;

import cn.hutool.core.map.MapUtil;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.util.HashMap;
import java.util.Map;
import net.mingsoft.basic.util.SpringUtil;
import net.mingsoft.mdiy.biz.IConfigBiz;
import net.mingsoft.mdiy.entity.ConfigEntity;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class ConfigUtil {
    public static Map<String, ConfigEntity> CONFIG_HASH_MAP = MapUtil.newHashMap();

    public static String getString(String configName, String key) {
        Object object = ConfigUtil.getObject(configName, key);
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    public static String getString(String configName, String key, String defaultValue) {
        Object object = ConfigUtil.getObject(configName, key);
        if (object == null) {
            return defaultValue;
        }
        return object.toString();
    }

    public static Boolean getBoolean(String configName, String key) {
        Object object = ConfigUtil.getObject(configName, key);
        if (object == null) {
            return Boolean.FALSE;
        }
        return BooleanUtils.toBoolean((String)object.toString());
    }

    public static Boolean getBoolean(String configName, String key, Boolean defaultValue) {
        Object object = ConfigUtil.getObject(configName, key);
        if (object == null) {
            return defaultValue;
        }
        return BooleanUtils.toBoolean((String)object.toString());
    }

    public static int getInt(String configName, String key) {
        Object object = ConfigUtil.getObject(configName, key);
        if (object == null) {
            return 0;
        }
        return Integer.parseInt(object.toString());
    }

    public static int getInt(String configName, String key, int defaultValue) {
        Object object = ConfigUtil.getObject(configName, key);
        if (object == null) {
            return defaultValue;
        }
        return Integer.parseInt(object.toString());
    }

    public static Object getObject(String configName, String key) {
        ConfigEntity configEntity = ConfigUtil.getEntity(configName);
        if (configEntity == null) {
            return null;
        }
        HashMap map = (HashMap)JSONUtil.toBean((String)configEntity.getConfigData(), HashMap.class);
        if (map != null) {
            return map.get(key);
        }
        return null;
    }

    public static Map getMap(String configName) {
        ConfigEntity configEntity = ConfigUtil.getEntity(configName);
        if (configEntity == null || StringUtils.isEmpty((CharSequence)configEntity.getConfigData())) {
            return null;
        }
        return (Map)JSONUtil.toBean((String)configEntity.getConfigData(), HashMap.class);
    }

    public static ConfigEntity getEntity(String configName) {
        if (StringUtils.isEmpty((CharSequence)configName) || StringUtils.isEmpty((CharSequence)configName)) {
            return null;
        }
        if (CONFIG_HASH_MAP.get(configName) != null) {
            return CONFIG_HASH_MAP.get(configName);
        }
        IConfigBiz configBiz = (IConfigBiz)SpringUtil.getBean(IConfigBiz.class);
        ConfigEntity configEntity = new ConfigEntity();
        configEntity.setConfigName(configName);
        configEntity = (ConfigEntity)((Object)configBiz.getOne((Wrapper)new QueryWrapper((Object)configEntity)));
        if (configEntity == null) {
            return null;
        }
        CONFIG_HASH_MAP.put(configName, configEntity);
        return configEntity;
    }
}

