/*
 * Decompiled with CFR 0.152.
 */
package net.nicoulaj.maven.plugins.checksum.mojo;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.nicoulaj.maven.plugins.checksum.Constants;
import net.nicoulaj.maven.plugins.checksum.artifacts.ArtifactAttacher;
import net.nicoulaj.maven.plugins.checksum.artifacts.ArtifactListener;
import net.nicoulaj.maven.plugins.checksum.execution.AbstractExecution;
import net.nicoulaj.maven.plugins.checksum.execution.ExecutionException;
import net.nicoulaj.maven.plugins.checksum.execution.FailOnErrorExecution;
import net.nicoulaj.maven.plugins.checksum.execution.NeverFailExecution;
import net.nicoulaj.maven.plugins.checksum.execution.target.CsvSummaryFileTarget;
import net.nicoulaj.maven.plugins.checksum.execution.target.MavenLogTarget;
import net.nicoulaj.maven.plugins.checksum.execution.target.OneHashPerFileTarget;
import net.nicoulaj.maven.plugins.checksum.execution.target.ShasumSummaryFileTarget;
import net.nicoulaj.maven.plugins.checksum.execution.target.XmlSummaryFileTarget;
import net.nicoulaj.maven.plugins.checksum.mojo.ChecksumFile;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

abstract class AbstractChecksumMojo
extends AbstractMojo {
    private boolean defaultFailIfNoFiles;
    private final boolean failIfNoAlgorithms;
    private final boolean failIfNoTargets;
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Component
    protected MavenProjectHelper projectHelper;
    @Parameter
    protected List<String> algorithms = Arrays.asList(Constants.DEFAULT_EXECUTION_ALGORITHMS);
    @Parameter(defaultValue="true")
    protected boolean failOnError;
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    protected String encoding = "UTF-8";
    @Parameter(property="attachChecksums", defaultValue="false")
    protected boolean attachChecksums;
    @Parameter(defaultValue="false")
    protected boolean quiet;
    @Parameter(defaultValue="false")
    protected boolean includeRelativePath;
    @Parameter(defaultValue="")
    protected String relativeSubPath = "";

    AbstractChecksumMojo(boolean failIfNoFiles, boolean failIfNoAlgorithms, boolean failIfNoTargets) {
        this.defaultFailIfNoFiles = failIfNoFiles;
        this.failIfNoAlgorithms = failIfNoAlgorithms;
        this.failIfNoTargets = failIfNoTargets;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        AbstractExecution execution = this.failOnError ? new FailOnErrorExecution() : new NeverFailExecution(this.getLog());
        execution.setAlgorithms(this.algorithms);
        execution.setFiles(this.getFilesToProcess());
        execution.setFailIfNoFiles(this.isFailIfNoFiles());
        execution.setFailIfNoAlgorithms(this.failIfNoAlgorithms);
        execution.setFailIfNoTargets(this.failIfNoTargets);
        if (!this.quiet) {
            execution.addTarget(new MavenLogTarget(this.getLog()));
        }
        if (this.includeRelativePath) {
            execution.setSubPath(this.relativeSubPath);
        } else {
            execution.setSubPath(null);
        }
        if (this.isIndividualFiles()) {
            File outputDirectory = null;
            if (StringUtils.isNotEmpty((String)this.getIndividualFilesOutputDirectory())) {
                outputDirectory = FileUtils.resolveFile((File)new File(this.project.getBuild().getDirectory()), (String)this.getIndividualFilesOutputDirectory());
            }
            execution.addTarget(new OneHashPerFileTarget(this.encoding, outputDirectory, this.createArtifactListeners(), this.isAppendFilename()));
        }
        if (this.isCsvSummary()) {
            execution.addTarget(new CsvSummaryFileTarget(FileUtils.resolveFile((File)new File(this.project.getBuild().getDirectory()), (String)this.getCsvSummaryFile()), this.encoding, this.createArtifactListeners()));
        }
        if (this.isXmlSummary()) {
            execution.addTarget(new XmlSummaryFileTarget(FileUtils.resolveFile((File)new File(this.project.getBuild().getDirectory()), (String)this.getXmlSummaryFile()), this.encoding, this.createArtifactListeners()));
        }
        if (this.isShasumSummary()) {
            execution.addTarget(new ShasumSummaryFileTarget(FileUtils.resolveFile((File)new File(this.project.getBuild().getDirectory()), (String)this.getShasumSummaryFile()), this.createArtifactListeners()));
        }
        try {
            execution.run();
        }
        catch (ExecutionException e) {
            this.getLog().error((CharSequence)e.getMessage());
            throw new MojoFailureException(e.getMessage());
        }
    }

    private Iterable<? extends ArtifactListener> createArtifactListeners() {
        if (!this.attachChecksums) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new ArtifactAttacher(this.project, this.projectHelper));
    }

    protected abstract List<ChecksumFile> getFilesToProcess();

    protected abstract boolean isIndividualFiles();

    protected boolean isAppendFilename() {
        return false;
    }

    protected abstract String getIndividualFilesOutputDirectory();

    protected abstract boolean isCsvSummary();

    protected abstract String getCsvSummaryFile();

    protected abstract boolean isXmlSummary();

    protected abstract String getXmlSummaryFile();

    protected abstract boolean isShasumSummary();

    protected abstract String getShasumSummaryFile();

    protected boolean isFailIfNoFiles() {
        return this.defaultFailIfNoFiles;
    }
}

