/*
 * Decompiled with CFR 0.152.
 */
package net.nicoulaj.maven.plugins.checksum.mojo;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.nicoulaj.maven.plugins.checksum.mojo.AbstractChecksumMojo;
import net.nicoulaj.maven.plugins.checksum.mojo.ChecksumFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="dependencies", defaultPhase=LifecyclePhase.VERIFY, requiresProject=true, inheritByDefault=false, requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true)
public class DependenciesMojo
extends AbstractChecksumMojo {
    public static final String NAME = "dependencies";
    @Parameter(defaultValue="false")
    protected boolean individualFiles;
    @Parameter(defaultValue="${project.build.directory}")
    protected String individualFilesOutputDirectory;
    @Parameter(defaultValue="true")
    protected boolean csvSummary;
    @Parameter(defaultValue="dependencies-checksums.csv")
    protected String csvSummaryFile;
    @Parameter(defaultValue="false")
    protected boolean xmlSummary;
    @Parameter(defaultValue="dependencies-checksums.xml")
    protected String xmlSummaryFile;
    @Parameter(defaultValue="false")
    protected boolean shasumSummary;
    @Parameter(defaultValue="dependencies-checksums.sha")
    protected String shasumSummaryFile;
    @Parameter
    protected List<String> scopes;
    @Parameter
    protected List<String> types;
    @Parameter(defaultValue="false")
    protected boolean transitive;

    public DependenciesMojo() {
        super(false, true, true);
    }

    @Override
    protected List<ChecksumFile> getFilesToProcess() {
        LinkedList<ChecksumFile> files = new LinkedList<ChecksumFile>();
        Set artifacts = this.transitive ? this.project.getArtifacts() : this.project.getDependencyArtifacts();
        for (Artifact artifact : artifacts) {
            if (this.scopes != null && !this.scopes.contains(artifact.getScope()) || this.types != null && !this.types.contains(artifact.getType())) continue;
            files.add(new ChecksumFile("", artifact.getFile(), artifact.getType(), artifact.getClassifier()));
        }
        return files;
    }

    @Override
    protected boolean isIndividualFiles() {
        return this.individualFiles;
    }

    @Override
    protected String getIndividualFilesOutputDirectory() {
        return this.individualFilesOutputDirectory;
    }

    @Override
    protected boolean isCsvSummary() {
        return this.csvSummary;
    }

    @Override
    protected String getCsvSummaryFile() {
        return this.csvSummaryFile;
    }

    @Override
    protected boolean isXmlSummary() {
        return this.xmlSummary;
    }

    @Override
    protected String getXmlSummaryFile() {
        return this.xmlSummaryFile;
    }

    @Override
    protected boolean isShasumSummary() {
        return this.shasumSummary;
    }

    @Override
    protected String getShasumSummaryFile() {
        return this.shasumSummaryFile;
    }
}

