/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.profile;

import com.vaadin.event.Action;
import com.vaadin.event.ShortcutAction;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.GridLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.PasswordField;
import com.vaadin.ui.VerticalLayout;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.identity.User;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.I18nManager;
import org.activiti.explorer.identity.LoggedInUser;
import org.activiti.explorer.ui.custom.PopupWindow;

public class ChangePasswordPopupWindow
extends PopupWindow {
    private static final long serialVersionUID = 1L;
    protected transient IdentityService identityService = ProcessEngines.getDefaultProcessEngine().getIdentityService();
    protected LoggedInUser currentUser = ExplorerApp.get().getLoggedInUser();
    protected I18nManager i18nManager = ExplorerApp.get().getI18nManager();
    protected VerticalLayout layout;
    protected GridLayout inputGrid;
    protected PasswordField passwordField1;
    protected PasswordField passwordField2;
    protected Label errorLabel;

    public ChangePasswordPopupWindow() {
        this.setCaption(this.i18nManager.getMessage("password.change"));
        this.setModal(true);
        this.center();
        this.addStyleName("light");
        this.setWidth(350.0f, 0);
        this.setHeight(205.0f, 0);
        this.initLayout();
        this.initPasswordFields();
        this.initChangePasswordButton();
        this.initEnterKeyListener();
    }

    protected void initLayout() {
        this.layout = new VerticalLayout();
        this.layout.setMargin(true);
        this.layout.setSpacing(true);
        this.setContent((ComponentContainer)this.layout);
    }

    protected void initPasswordFields() {
        this.inputGrid = new GridLayout(2, 2);
        this.inputGrid.setSpacing(true);
        this.layout.addComponent((Component)this.inputGrid);
        this.layout.setComponentAlignment((Component)this.inputGrid, Alignment.MIDDLE_CENTER);
        Label newPasswordLabel = new Label(this.i18nManager.getMessage("profile.new.password"));
        this.inputGrid.addComponent((Component)newPasswordLabel);
        this.passwordField1 = new PasswordField();
        this.passwordField1.setWidth(150.0f, 0);
        this.inputGrid.addComponent((Component)this.passwordField1);
        this.passwordField1.focus();
        Label confirmPasswordLabel = new Label(this.i18nManager.getMessage("profile.confirm.password"));
        this.inputGrid.addComponent((Component)confirmPasswordLabel);
        this.passwordField2 = new PasswordField();
        this.passwordField2.setWidth(150.0f, 0);
        this.inputGrid.addComponent((Component)this.passwordField2);
    }

    protected void initChangePasswordButton() {
        this.errorLabel = new Label("&nbsp", 3);
        this.errorLabel.addStyleName("light");
        this.errorLabel.addStyleName("red");
        this.layout.addComponent((Component)this.errorLabel);
        Button changePasswordButton = new Button(this.i18nManager.getMessage("password.change"));
        this.layout.addComponent((Component)changePasswordButton);
        this.layout.setComponentAlignment((Component)changePasswordButton, Alignment.MIDDLE_CENTER);
        changePasswordButton.addListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                ChangePasswordPopupWindow.this.handlePasswordChange();
            }
        });
    }

    protected void initEnterKeyListener() {
        this.addActionHandler(new Action.Handler(){

            public void handleAction(Action action, Object sender, Object target) {
                ChangePasswordPopupWindow.this.handlePasswordChange();
            }

            public Action[] getActions(Object target, Object sender) {
                return new Action[]{new ShortcutAction("enter", 13, null)};
            }
        });
    }

    protected void handlePasswordChange() {
        if (this.passwordField1.getValue() == null || "".equals(this.passwordField1.getValue().toString()) || this.passwordField2.getValue() == null || "".equals(this.passwordField2.getValue().toString())) {
            this.errorLabel.setValue((Object)this.i18nManager.getMessage("password.change.input.required"));
        } else if (!this.passwordField1.getValue().equals(this.passwordField2.getValue())) {
            this.errorLabel.setValue((Object)this.i18nManager.getMessage("password.change.input.match"));
        } else {
            String password = this.passwordField1.getValue().toString();
            User user = (User)this.identityService.createUserQuery().userId(this.currentUser.getId()).singleResult();
            user.setPassword(password);
            this.identityService.saveUser(user);
            ExplorerApp.get().setUser(ExplorerApp.get().getLoginHandler().authenticate(user.getId(), user.getPassword()));
            this.close();
            ExplorerApp.get().getNotificationManager().showInformationNotification("password.changed.notification");
        }
    }
}

