/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.auth;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.flume.auth.FlumeAuthenticator;
import org.apache.flume.auth.PrivilegedExecutor;
import org.apache.flume.auth.SecurityException;
import org.apache.flume.auth.UGIExecutor;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KerberosAuthenticator
implements FlumeAuthenticator {
    private static final Logger LOG = LoggerFactory.getLogger(KerberosAuthenticator.class);
    private volatile UserGroupInformation ugi;
    private volatile PrivilegedExecutor privilegedExecutor;
    private Map<String, PrivilegedExecutor> proxyCache = new HashMap<String, PrivilegedExecutor>();

    KerberosAuthenticator() {
    }

    @Override
    public <T> T execute(PrivilegedAction<T> action) {
        return this.privilegedExecutor.execute(action);
    }

    @Override
    public <T> T execute(PrivilegedExceptionAction<T> action) throws Exception {
        return this.privilegedExecutor.execute(action);
    }

    @Override
    public synchronized PrivilegedExecutor proxyAs(String proxyUserName) {
        if (proxyUserName == null || proxyUserName.isEmpty()) {
            return this;
        }
        if (this.proxyCache.get(proxyUserName) == null) {
            UserGroupInformation proxyUgi = UserGroupInformation.createProxyUser((String)proxyUserName, (UserGroupInformation)this.ugi);
            this.printUGI(proxyUgi);
            this.proxyCache.put(proxyUserName, new UGIExecutor(proxyUgi));
        }
        return this.proxyCache.get(proxyUserName);
    }

    @Override
    public boolean isAuthenticated() {
        return true;
    }

    public synchronized void authenticate(String principal, String keytab) {
        String resolvedPrincipal;
        Preconditions.checkArgument((principal != null && !principal.isEmpty() ? 1 : 0) != 0, (Object)("Invalid Kerberos principal: " + String.valueOf(principal)));
        Preconditions.checkArgument((keytab != null && !keytab.isEmpty() ? 1 : 0) != 0, (Object)("Invalid Kerberos keytab: " + String.valueOf(keytab)));
        File keytabFile = new File(keytab);
        Preconditions.checkArgument((keytabFile.isFile() && keytabFile.canRead() ? 1 : 0) != 0, (Object)("Keytab is not a readable file: " + String.valueOf(keytab)));
        try {
            resolvedPrincipal = SecurityUtil.getServerPrincipal((String)principal, (String)"");
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Host lookup error resolving kerberos principal (" + principal + "). Exception follows.", e);
        }
        Preconditions.checkNotNull((Object)resolvedPrincipal, (Object)"Resolved Principal must not be null");
        Preconditions.checkState((this.ugi == null || this.ugi.getUserName().equals(resolvedPrincipal) ? 1 : 0) != 0, (String)"Cannot use multiple kerberos principals in the same agent.  Must restart agent to use new principal or keytab. Previous = %s, New = %s", (Object[])new Object[]{this.ugi, resolvedPrincipal});
        if (!UserGroupInformation.isSecurityEnabled()) {
            Configuration conf = new Configuration(false);
            conf.set("hadoop.security.authentication", "kerberos");
            UserGroupInformation.setConfiguration((Configuration)conf);
        }
        UserGroupInformation curUser = null;
        try {
            curUser = UserGroupInformation.getLoginUser();
            if (curUser != null && !curUser.hasKerberosCredentials()) {
                curUser = null;
            }
        }
        catch (IOException e) {
            LOG.warn("User unexpectedly had no active login. Continuing with authentication", (Throwable)e);
        }
        try {
            if (this.ugi != null) {
                if (curUser != null && curUser.getUserName().equals(this.ugi.getUserName())) {
                    LOG.debug("Using existing principal login: {}", (Object)this.ugi);
                } else {
                    LOG.info("Attempting kerberos Re-login as principal ({}) ", new Object[]{this.ugi.getUserName()});
                    this.ugi.reloginFromKeytab();
                }
            } else {
                LOG.info("Attempting kerberos login as principal ({}) from keytab file ({})", new Object[]{resolvedPrincipal, keytab});
                UserGroupInformation.loginUserFromKeytab((String)resolvedPrincipal, (String)keytab);
                this.ugi = UserGroupInformation.getLoginUser();
                this.privilegedExecutor = new UGIExecutor(this.ugi);
            }
        }
        catch (IOException e) {
            throw new SecurityException("Authentication error while attempting to login as kerberos principal (" + resolvedPrincipal + ") using " + "keytab (" + keytab + "). Exception follows.", e);
        }
        this.printUGI(this.ugi);
    }

    private void printUGI(UserGroupInformation ugi) {
        if (ugi != null) {
            UserGroupInformation.AuthenticationMethod authMethod = ugi.getAuthenticationMethod();
            LOG.info("\n{} \nUser: {} \nAuth method: {} \nKeytab: {} \n", new Object[]{authMethod.equals((Object)UserGroupInformation.AuthenticationMethod.PROXY) ? "Proxy as: " : "Logged as: ", ugi.getUserName(), authMethod, ugi.isFromKeytab()});
        }
    }

    @Override
    public void startCredentialRefresher() {
        int CHECK_TGT_INTERVAL = 120;
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
        scheduler.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    KerberosAuthenticator.this.ugi.checkTGTAndReloginFromKeytab();
                }
                catch (IOException e) {
                    LOG.warn("Error occured during checkTGTAndReloginFromKeytab() for user " + KerberosAuthenticator.this.ugi.getUserName(), (Throwable)e);
                }
            }
        }, CHECK_TGT_INTERVAL, CHECK_TGT_INTERVAL, TimeUnit.SECONDS);
    }

    @VisibleForTesting
    String getUserName() {
        if (this.ugi != null) {
            return this.ugi.getUserName();
        }
        return null;
    }
}

