/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.viewer.services;

import com.google.common.base.Charsets;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.CharSource;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.i18n.TranslationsResolver;
import org.apache.isis.viewer.wicket.viewer.IsisWicketApplication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DomainService(nature=NatureOfService.DOMAIN)
public class TranslationsResolverWicket
implements TranslationsResolver {
    public static Logger LOG = LoggerFactory.getLogger(TranslationsResolverWicket.class);
    private static final Pattern nonEmpty = Pattern.compile("^(#:|msgid|msgstr).+$");

    @Programmatic
    public List<String> readLines(String file) {
        ServletContext servletContext = this.getServletContext();
        String configLocation = servletContext.getInitParameter("isis.config.dir");
        try {
            if (configLocation != null) {
                LOG.info("Reading translations relative to config override location: " + configLocation);
                return Files.readLines((File)TranslationsResolverWicket.newFile(configLocation, file), (Charset)Charsets.UTF_8);
            }
            URL url = servletContext.getResource("/WEB-INF/" + file);
            return TranslationsResolverWicket.readLines(url);
        }
        catch (IOException | RuntimeException ignored) {
            return null;
        }
    }

    static File newFile(String dir, String file) {
        File base = new File(dir);
        Path path = base.toPath();
        Path resolve = path.resolve(file);
        return resolve.toFile();
    }

    protected ServletContext getServletContext() {
        return this.getIsisWicketApplication().getServletContext();
    }

    private static List<String> readLines(URL url) throws IOException {
        if (url == null) {
            return null;
        }
        CharSource charSource = Resources.asCharSource((URL)url, (Charset)Charsets.UTF_8);
        ImmutableList strings = charSource.readLines();
        return Collections.unmodifiableList(Lists.newArrayList((Iterable)Iterables.filter((Iterable)strings, (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return input != null && nonEmpty.matcher(input).matches();
            }
        })));
    }

    protected IsisWicketApplication getIsisWicketApplication() {
        return IsisWicketApplication.get();
    }
}

