/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.viewer.settings;

import com.google.inject.Singleton;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettings;

@Singleton
public class WicketViewerSettingsDefault
implements WicketViewerSettings {
    private static final long serialVersionUID = 1L;

    IsisConfiguration getConfiguration() {
        return IsisContext.getConfiguration();
    }

    public int getMaxTitleLengthInStandaloneTables() {
        return this.getConfiguration().getInteger("isis.viewer.wicket.maxTitleLengthInStandaloneTables", this.getMaxTitleLengthInTables());
    }

    public int getMaxTitleLengthInParentedTables() {
        return this.getConfiguration().getInteger("isis.viewer.wicket.maxTitleLengthInParentedTables", this.getMaxTitleLengthInTables());
    }

    private int getMaxTitleLengthInTables() {
        return this.getConfiguration().getInteger("isis.viewer.wicket.maxTitleLengthInTables", 12);
    }

    public String getDatePattern() {
        return this.getConfiguration().getString("isis.viewer.wicket.datePattern", "dd-MM-yyyy");
    }

    public String getDateTimePattern() {
        return this.getConfiguration().getString("isis.viewer.wicket.dateTimePattern", "dd-MM-yyyy HH:mm");
    }

    public String getTimestampPattern() {
        return this.getConfiguration().getString("isis.viewer.wicket.timestampPattern", "yyyy-MM-dd HH:mm:ss.SSS");
    }

    public String getDatePickerPattern() {
        return this.getConfiguration().getString("isis.viewer.wicket.datePickerPattern", "DD-MM-YYYY");
    }
}

