/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.model.mementos;

import java.io.Serializable;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.viewer.wicket.model.mementos.SpecUtils;

public class CollectionMemento
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ObjectSpecId owningType;
    private final String id;
    private transient OneToManyAssociation collection;

    private static ObjectSpecification owningSpecFor(OneToManyAssociation association) {
        return IsisContext.getSpecificationLoader().loadSpecification(association.getIdentifier().toClassIdentityString());
    }

    public CollectionMemento(ObjectSpecId owningType, String id) {
        this(owningType, id, CollectionMemento.collectionFor(owningType, id));
    }

    public CollectionMemento(OneToManyAssociation collection) {
        this(CollectionMemento.owningSpecFor(collection).getSpecId(), collection.getIdentifier().toNameIdentityString(), collection);
    }

    private CollectionMemento(ObjectSpecId owningType, String id, OneToManyAssociation collection) {
        this.owningType = owningType;
        this.id = id;
        this.collection = collection;
    }

    public ObjectSpecId getOwningType() {
        return this.owningType;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.getCollection().getName();
    }

    public OneToManyAssociation getCollection() {
        if (this.collection == null) {
            this.collection = CollectionMemento.collectionFor(this.owningType, this.id);
        }
        return this.collection;
    }

    private static OneToManyAssociation collectionFor(ObjectSpecId owningType, String id) {
        return (OneToManyAssociation)SpecUtils.getSpecificationFor(owningType).getAssociation(id);
    }
}

