/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.model.models;

import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.isis.applib.Identifier;
import org.apache.isis.applib.RecoverableException;
import org.apache.isis.applib.annotation.BookmarkPolicy;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.value.Blob;
import org.apache.isis.applib.value.Clob;
import org.apache.isis.applib.value.NamedWithMimeType;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.oid.OidMarshaller;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.adapter.oid.RootOidDefault;
import org.apache.isis.core.metamodel.adapter.oid.TypedOid;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.facets.object.bookmarkpolicy.BookmarkPolicyFacet;
import org.apache.isis.core.metamodel.facets.object.encodeable.EncodableFacet;
import org.apache.isis.core.metamodel.spec.ActionType;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.viewer.wicket.model.common.PageParametersUtils;
import org.apache.isis.viewer.wicket.model.mementos.ActionMemento;
import org.apache.isis.viewer.wicket.model.mementos.ActionParameterMemento;
import org.apache.isis.viewer.wicket.model.mementos.ObjectAdapterMemento;
import org.apache.isis.viewer.wicket.model.mementos.PageParameterNames;
import org.apache.isis.viewer.wicket.model.models.ActionExecutor;
import org.apache.isis.viewer.wicket.model.models.BookmarkableModel;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.handler.resource.ResourceStreamRequestHandler;
import org.apache.wicket.request.http.handler.RedirectRequestHandler;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.ContentDisposition;
import org.apache.wicket.util.resource.AbstractResourceStream;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.resource.StringResourceStream;

public class ActionModel
extends BookmarkableModel<ObjectAdapter> {
    private static final long serialVersionUID = 1L;
    private static final String NULL_ARG = "$nullArg$";
    private static final Pattern KEY_VALUE_PATTERN = Pattern.compile("([^=]+)=(.+)");
    private final ObjectAdapterMemento targetAdapterMemento;
    private final ActionMemento actionMemento;
    private Mode actionMode;
    private final Map<Integer, ScalarModel> arguments = Maps.newHashMap();
    private ActionExecutor executor;
    public static final Where WHERE_FOR_ACTION_INVOCATION = Where.ANYWHERE;

    public static ActionModel create(ObjectAdapter objectAdapter, ObjectAction action) {
        ObjectAdapterMemento serviceMemento = (ObjectAdapterMemento)ObjectAdapterMemento.Functions.fromAdapter().apply((Object)objectAdapter);
        ActionMemento homePageActionMemento = (ActionMemento)ObjectAdapterMemento.Functions.fromAction().apply((Object)action);
        Mode mode = action.getParameterCount() > 0 ? Mode.PARAMETERS : Mode.RESULTS;
        return new ActionModel(serviceMemento, homePageActionMemento, mode);
    }

    public static ActionModel createForPersistent(PageParameters pageParameters) {
        return new ActionModel(pageParameters);
    }

    public static PageParameters createPageParameters(ObjectAdapter adapter, ObjectAction objectAction, AdapterManager.ConcurrencyChecking concurrencyChecking) {
        PageParameters pageParameters = PageParametersUtils.newPageParameters();
        String oidStr = concurrencyChecking == AdapterManager.ConcurrencyChecking.CHECK ? adapter.getOid().enString(ActionModel.getOidMarshaller()) : adapter.getOid().enStringNoVersion(ActionModel.getOidMarshaller());
        PageParameterNames.OBJECT_OID.addStringTo(pageParameters, oidStr);
        ActionType actionType = objectAction.getType();
        PageParameterNames.ACTION_TYPE.addEnumTo(pageParameters, (Enum<?>)actionType);
        ObjectSpecification actionOnTypeSpec = objectAction.getOnType();
        if (actionOnTypeSpec != null) {
            PageParameterNames.ACTION_OWNING_SPEC.addStringTo(pageParameters, actionOnTypeSpec.getFullIdentifier());
        }
        String actionId = ActionModel.determineActionId(objectAction);
        PageParameterNames.ACTION_ID.addStringTo(pageParameters, actionId);
        return pageParameters;
    }

    public static Map.Entry<Integer, String> parse(String paramContext) {
        String oidStr;
        int paramNum;
        Matcher matcher = KEY_VALUE_PATTERN.matcher(paramContext);
        if (!matcher.matches()) {
            return null;
        }
        try {
            paramNum = Integer.parseInt(matcher.group(1));
        }
        catch (Exception e) {
            return null;
        }
        try {
            oidStr = matcher.group(2);
        }
        catch (Exception e) {
            return null;
        }
        return new Map.Entry<Integer, String>(){

            @Override
            public Integer getKey() {
                return paramNum;
            }

            @Override
            public String getValue() {
                return oidStr;
            }

            @Override
            public String setValue(String value) {
                return null;
            }
        };
    }

    @Override
    public PageParameters getPageParameters() {
        ObjectAdapter[] argumentsAsArray;
        ObjectAdapter adapter = this.getTargetAdapter();
        ObjectAction objectAction = this.getActionMemento().getAction();
        PageParameters pageParameters = ActionModel.createPageParameters(adapter, objectAction, AdapterManager.ConcurrencyChecking.NO_CHECK);
        for (ObjectAdapter argumentAdapter : argumentsAsArray = this.getArgumentsAsArray()) {
            String encodedArg = this.encodeArg(argumentAdapter);
            PageParameterNames.ACTION_ARGS.addStringTo(pageParameters, encodedArg);
        }
        return pageParameters;
    }

    @Override
    public String getTitle() {
        ObjectAdapter[] argumentsAsArray;
        ObjectAdapter adapter = this.getTargetAdapter();
        ObjectAction objectAction = this.getActionMemento().getAction();
        StringBuilder buf = new StringBuilder();
        for (ObjectAdapter argumentAdapter : argumentsAsArray = this.getArgumentsAsArray()) {
            if (buf.length() > 0) {
                buf.append(",");
            }
            buf.append(ActionModel.abbreviated(ActionModel.titleOf(argumentAdapter), 8));
        }
        return adapter.titleString(null) + "." + objectAction.getName() + (buf.length() > 0 ? "(" + buf.toString() + ")" : "");
    }

    @Override
    public boolean hasAsRootPolicy() {
        return true;
    }

    private static String titleOf(ObjectAdapter argumentAdapter) {
        return argumentAdapter != null ? argumentAdapter.titleString(null) : "";
    }

    private static String abbreviated(String str, int maxLength) {
        return str.length() < maxLength ? str : str.substring(0, maxLength - 3) + "...";
    }

    private static String determineActionId(ObjectAction objectAction) {
        Identifier identifier = objectAction.getIdentifier();
        if (identifier != null) {
            return identifier.toNameParmsIdentityString();
        }
        return objectAction.getId();
    }

    public static Mode determineMode(ObjectAction action) {
        return action.getParameterCount() > 0 ? Mode.PARAMETERS : Mode.RESULTS;
    }

    private ActionModel(PageParameters pageParameters) {
        this(ActionModel.newObjectAdapterMementoFrom(pageParameters), ActionModel.newActionMementoFrom(pageParameters), ActionModel.actionModeFrom(pageParameters));
        this.setArgumentsIfPossible(pageParameters);
        this.setContextArgumentIfPossible(pageParameters);
    }

    private static ActionMemento newActionMementoFrom(PageParameters pageParameters) {
        ObjectSpecId owningSpec = ObjectSpecId.of((String)PageParameterNames.ACTION_OWNING_SPEC.getStringFrom(pageParameters));
        ActionType actionType = PageParameterNames.ACTION_TYPE.getEnumFrom(pageParameters, ActionType.class);
        String actionNameParms = PageParameterNames.ACTION_ID.getStringFrom(pageParameters);
        return new ActionMemento(owningSpec, actionType, actionNameParms);
    }

    private static Mode actionModeFrom(PageParameters pageParameters) {
        ActionMemento actionMemento = ActionModel.newActionMementoFrom(pageParameters);
        if (actionMemento.getAction().getParameterCount() == 0) {
            return Mode.RESULTS;
        }
        List<String> listFrom = PageParameterNames.ACTION_ARGS.getListFrom(pageParameters);
        return !listFrom.isEmpty() ? Mode.RESULTS : Mode.PARAMETERS;
    }

    private static ObjectAdapterMemento newObjectAdapterMementoFrom(PageParameters pageParameters) {
        RootOid oid = ActionModel.oidFor(pageParameters);
        if (oid.isTransient()) {
            return null;
        }
        return ObjectAdapterMemento.createPersistent(oid);
    }

    private static RootOid oidFor(PageParameters pageParameters) {
        String oidStr = PageParameterNames.OBJECT_OID.getStringFrom(pageParameters);
        return (RootOid)ActionModel.getOidMarshaller().unmarshal(oidStr, RootOid.class);
    }

    private ActionModel(ObjectAdapterMemento adapterMemento, ActionMemento actionMemento, Mode actionMode) {
        this.targetAdapterMemento = adapterMemento;
        this.actionMemento = actionMemento;
        this.actionMode = actionMode;
    }

    private ActionModel(ActionModel actionModel) {
        this.targetAdapterMemento = actionModel.targetAdapterMemento;
        this.actionMemento = actionModel.actionMemento;
        this.actionMode = actionModel.actionMode;
        this.primeArgumentModels();
        Map<Integer, ScalarModel> argumentModelByIdx = actionModel.arguments;
        for (Map.Entry<Integer, ScalarModel> argumentModel : argumentModelByIdx.entrySet()) {
            this.setArgument(argumentModel.getKey(), (ObjectAdapter)argumentModel.getValue().getObject());
        }
        this.executor = actionModel.executor;
    }

    private void setArgumentsIfPossible(PageParameters pageParameters) {
        List<String> args = PageParameterNames.ACTION_ARGS.getListFrom(pageParameters);
        ObjectAction action = this.actionMemento.getAction();
        List parameterTypes = action.getParameterTypes();
        for (int paramNum = 0; paramNum < args.size(); ++paramNum) {
            String encoded = args.get(paramNum);
            this.setArgument(paramNum, (ObjectSpecification)parameterTypes.get(paramNum), encoded);
        }
    }

    public boolean hasParameters() {
        return this.actionMode == Mode.PARAMETERS;
    }

    private boolean setContextArgumentIfPossible(PageParameters pageParameters) {
        String paramContext = PageParameterNames.ACTION_PARAM_CONTEXT.getStringFrom(pageParameters);
        if (paramContext == null) {
            return false;
        }
        ObjectAction action = this.actionMemento.getAction();
        List parameterTypes = action.getParameterTypes();
        int parameterCount = parameterTypes.size();
        Map.Entry<Integer, String> mapEntry = ActionModel.parse(paramContext);
        int paramNum = mapEntry.getKey();
        if (paramNum >= parameterCount) {
            return false;
        }
        String encoded = mapEntry.getValue();
        this.setArgument(paramNum, (ObjectSpecification)parameterTypes.get(paramNum), encoded);
        return true;
    }

    private void setArgument(int paramNum, ObjectSpecification argSpec, String encoded) {
        ObjectAdapter argumentAdapter = this.decodeArg(argSpec, encoded);
        this.setArgument(paramNum, argumentAdapter);
    }

    private String encodeArg(ObjectAdapter adapter) {
        if (adapter == null) {
            return NULL_ARG;
        }
        ObjectSpecification objSpec = adapter.getSpecification();
        if (objSpec.isEncodeable()) {
            EncodableFacet encodeable = (EncodableFacet)objSpec.getFacet(EncodableFacet.class);
            return encodeable.toEncodedString(adapter);
        }
        return adapter.getOid().enStringNoVersion(ActionModel.getOidMarshaller());
    }

    private ObjectAdapter decodeArg(ObjectSpecification objSpec, String encoded) {
        if (NULL_ARG.equals(encoded)) {
            return null;
        }
        if (objSpec.isEncodeable()) {
            EncodableFacet encodeable = (EncodableFacet)objSpec.getFacet(EncodableFacet.class);
            return encodeable.fromEncodedString(encoded);
        }
        try {
            RootOid oid = RootOidDefault.deStringEncoded((String)encoded, (OidMarshaller)ActionModel.getOidMarshaller());
            return this.getAdapterManager().adapterFor((TypedOid)oid);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void setArgument(int paramNum, ObjectAdapter argumentAdapter) {
        ObjectAction action = this.actionMemento.getAction();
        ObjectActionParameter actionParam = (ObjectActionParameter)action.getParameters().get(paramNum);
        ActionParameterMemento apm = new ActionParameterMemento(actionParam);
        ScalarModel argumentModel = this.getArgumentModel(apm);
        argumentModel.setObject(argumentAdapter);
    }

    public ScalarModel getArgumentModel(ActionParameterMemento apm) {
        int i = apm.getNumber();
        ScalarModel scalarModel = this.arguments.get(i);
        if (scalarModel == null) {
            scalarModel = new ScalarModel(this.targetAdapterMemento, apm);
            int number = scalarModel.getParameterMemento().getNumber();
            this.arguments.put(number, scalarModel);
        }
        return scalarModel;
    }

    public ObjectAdapter getTargetAdapter() {
        return this.targetAdapterMemento.getObjectAdapter(this.getConcurrencyChecking());
    }

    protected AdapterManager.ConcurrencyChecking getConcurrencyChecking() {
        return this.actionMemento.getConcurrencyChecking();
    }

    public ActionMemento getActionMemento() {
        return this.actionMemento;
    }

    protected ObjectAdapter load() {
        this.detach();
        ObjectAdapter results = this.executeAction();
        this.actionMode = Mode.RESULTS;
        return results;
    }

    private ObjectAdapter executeAction() {
        ObjectAdapter targetAdapter = this.getTargetAdapter();
        ObjectAdapter[] arguments = this.getArgumentsAsArray();
        ObjectAction action = this.getActionMemento().getAction();
        AuthenticationSession session = this.getAuthenticationSession();
        return action.executeWithRuleChecking(targetAdapter, arguments, session, WHERE_FOR_ACTION_INVOCATION);
    }

    public String getReasonInvalidIfAny() {
        ObjectAdapter targetAdapter = this.getTargetAdapter();
        ObjectAdapter[] proposedArguments = this.getArgumentsAsArray();
        ObjectAction objectAction = this.getActionMemento().getAction();
        Consent validity = objectAction.isProposedArgumentSetValid(targetAdapter, proposedArguments);
        return validity.isAllowed() ? null : validity.getReason();
    }

    public void setObject(ObjectAdapter object) {
        throw new UnsupportedOperationException("target adapter for ActionModel cannot be changed");
    }

    public ObjectAdapter[] getArgumentsAsArray() {
        if (this.arguments.size() < this.getActionMemento().getAction().getParameterCount()) {
            this.primeArgumentModels();
        }
        ObjectAction objectAction = this.getActionMemento().getAction();
        ObjectAdapter[] arguments = new ObjectAdapter[objectAction.getParameterCount()];
        for (int i = 0; i < arguments.length; ++i) {
            ScalarModel scalarModel = this.arguments.get(i);
            arguments[i] = (ObjectAdapter)scalarModel.getObject();
        }
        return arguments;
    }

    public ActionExecutor getExecutor() {
        return this.executor;
    }

    public void setExecutor(ActionExecutor executor) {
        this.executor = executor;
    }

    public void reset() {
        this.actionMode = ActionModel.determineMode(this.actionMemento.getAction());
    }

    public void clearArguments() {
        for (ScalarModel argumentModel : this.arguments.values()) {
            argumentModel.reset();
        }
        this.actionMode = ActionModel.determineMode(this.actionMemento.getAction());
    }

    public boolean isBookmarkable() {
        ObjectAction action = this.getActionMemento().getAction();
        BookmarkPolicyFacet bookmarkPolicy = (BookmarkPolicyFacet)action.getFacet(BookmarkPolicyFacet.class);
        boolean safeSemantics = action.getSemantics().isSafeInNature();
        return bookmarkPolicy.value() == BookmarkPolicy.AS_ROOT && safeSemantics;
    }

    public ObjectAdapter executeHandlingApplicationExceptions() {
        try {
            ObjectAdapter resultAdapter = (ObjectAdapter)this.getObject();
            return resultAdapter;
        }
        catch (RuntimeException ex) {
            RecoverableException appEx = ActionModel.getApplicationExceptionIfAny(ex);
            if (appEx != null) {
                IsisContext.getMessageBroker().setApplicationError(appEx.getMessage());
                return null;
            }
            throw ex;
        }
    }

    public static RecoverableException getApplicationExceptionIfAny(Exception ex) {
        Iterable appEx = Iterables.filter((Iterable)Throwables.getCausalChain((Throwable)ex), RecoverableException.class);
        Iterator iterator = appEx.iterator();
        return iterator.hasNext() ? (RecoverableException)iterator.next() : null;
    }

    public static IRequestHandler redirectHandler(Object value) {
        if (value instanceof URL) {
            URL url = (URL)value;
            return new RedirectRequestHandler(url.toString());
        }
        return null;
    }

    public static IRequestHandler downloadHandler(Object value) {
        if (value instanceof Clob) {
            Clob clob = (Clob)value;
            return ActionModel.handlerFor(ActionModel.resourceStreamFor(clob), (NamedWithMimeType)clob);
        }
        if (value instanceof Blob) {
            Blob blob = (Blob)value;
            return ActionModel.handlerFor(ActionModel.resourceStreamFor(blob), (NamedWithMimeType)blob);
        }
        return null;
    }

    private static IResourceStream resourceStreamFor(final Blob blob) {
        AbstractResourceStream resourceStream = new AbstractResourceStream(){
            private static final long serialVersionUID = 1L;

            public InputStream getInputStream() throws ResourceStreamNotFoundException {
                return new ByteArrayInputStream(blob.getBytes());
            }

            public String getContentType() {
                return blob.getMimeType().toString();
            }

            public void close() throws IOException {
            }
        };
        return resourceStream;
    }

    private static IResourceStream resourceStreamFor(Clob clob) {
        StringResourceStream resourceStream = new StringResourceStream(clob.getChars(), clob.getMimeType().toString());
        return resourceStream;
    }

    private static IRequestHandler handlerFor(IResourceStream resourceStream, NamedWithMimeType namedWithMimeType) {
        ResourceStreamRequestHandler handler = new ResourceStreamRequestHandler(resourceStream, namedWithMimeType.getName());
        handler.setContentDisposition(ContentDisposition.ATTACHMENT);
        return handler;
    }

    public List<ActionParameterMemento> primeArgumentModels() {
        ObjectAction objectAction = this.getActionMemento().getAction();
        List parameters = objectAction.getParameters();
        List<ActionParameterMemento> mementos = ActionModel.buildParameterMementos(parameters);
        for (ActionParameterMemento apm : mementos) {
            this.getArgumentModel(apm);
        }
        return mementos;
    }

    private static List<ActionParameterMemento> buildParameterMementos(List<ObjectActionParameter> parameters) {
        List parameterMementoList = Lists.transform(parameters, ObjectAdapterMemento.Functions.fromActionParameter());
        return Lists.newArrayList((Iterable)parameterMementoList);
    }

    private static OidMarshaller getOidMarshaller() {
        return IsisContext.getOidMarshaller();
    }

    public ActionModel copy() {
        return new ActionModel(this);
    }

    private static enum Mode {
        PARAMETERS,
        RESULTS;

    }
}

