/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.model.models;

import java.util.Comparator;
import org.apache.isis.core.metamodel.adapter.oid.OidMarshaller;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.SpecificationLoader;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.viewer.wicket.model.mementos.PageParameterNames;
import org.apache.isis.viewer.wicket.model.models.BookmarkTreeNode;
import org.apache.isis.viewer.wicket.model.models.PageType;
import org.apache.wicket.request.mapper.parameter.PageParameters;

final class BookmarkTreeNodeComparator
implements Comparator<BookmarkTreeNode> {
    BookmarkTreeNodeComparator() {
    }

    @Override
    public int compare(BookmarkTreeNode o1, BookmarkTreeNode o2) {
        String className2;
        PageType pageType2;
        PageType pageType1 = o1.getPageType();
        int pageTypeComparison = pageType1.compareTo(pageType2 = o2.getPageType());
        if (pageTypeComparison != 0) {
            return pageTypeComparison;
        }
        RootOid oid1 = o1.getOidNoVer();
        RootOid oid2 = o2.getOidNoVer();
        String className1 = this.classNameOf(oid1);
        int classNameComparison = className1.compareTo(className2 = this.classNameOf(oid2));
        if (classNameComparison != 0) {
            return classNameComparison;
        }
        String title1 = o1.getTitle();
        String title2 = o2.getTitle();
        return title1.compareTo(title2);
    }

    private String classNameOf(RootOid oid) {
        ObjectSpecId objectSpecId = oid.getObjectSpecId();
        return this.getSpecificationLoader().lookupBySpecId(objectSpecId).getIdentifier().getClassName();
    }

    private RootOid oidOf(PageParameters pp) {
        String oidStr = PageParameterNames.OBJECT_OID.getStringFrom(pp);
        return (RootOid)this.getOidMarshaller().unmarshal(oidStr, RootOid.class);
    }

    protected OidMarshaller getOidMarshaller() {
        return IsisContext.getOidMarshaller();
    }

    protected SpecificationLoader getSpecificationLoader() {
        return IsisContext.getSpecificationLoader();
    }
}

