/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.model.models;

import java.io.Serializable;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.viewer.wicket.model.mementos.ObjectAdapterMemento;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.wicket.model.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ScalarModelWithPending
extends Serializable {
    public ObjectAdapterMemento getPending();

    public void setPending(ObjectAdapterMemento var1);

    public ScalarModel getScalarModel();

    public static class Util {
        private static final Logger LOG = LoggerFactory.getLogger(Util.class);

        public static Model<ObjectAdapterMemento> createModel(final ScalarModelWithPending owner) {
            return new Model<ObjectAdapterMemento>(){
                private static final long serialVersionUID = 1L;

                public ObjectAdapterMemento getObject() {
                    if (owner.getPending() != null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("pending not null: " + owner.getPending().toString());
                        }
                        return owner.getPending();
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("pending is null");
                    }
                    ObjectAdapterMemento objectAdapterMemento = owner.getScalarModel().getObjectAdapterMemento();
                    owner.setPending(objectAdapterMemento);
                    return objectAdapterMemento;
                }

                public void setObject(ObjectAdapterMemento adapterMemento) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("setting to: " + adapterMemento != null ? adapterMemento.toString() : null);
                    }
                    owner.setPending(adapterMemento);
                    if (owner.getScalarModel() != null) {
                        if (adapterMemento == null) {
                            owner.getScalarModel().setObject((ObjectAdapter)null);
                        } else if (owner.getPending() != null) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("setting to pending: " + owner.getPending().toString());
                            }
                            owner.getScalarModel().setObject(owner.getPending().getObjectAdapter(AdapterManager.ConcurrencyChecking.NO_CHECK));
                        }
                    }
                }
            };
        }
    }
}

