/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.actionresponse;

import java.net.URL;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.viewer.wicket.model.models.VoidModel;
import org.apache.isis.viewer.wicket.ui.actionresponse.ActionResultResponse;
import org.apache.isis.viewer.wicket.ui.pages.voidreturn.VoidReturnPage;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.AbstractAjaxBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.handler.resource.ResourceStreamRequestHandler;
import org.apache.wicket.request.resource.ContentDisposition;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.time.Duration;

public enum ActionResultResponseHandlingStrategy {
    REDIRECT_TO_VOID{

        @Override
        public void handleResults(Component component, ActionResultResponse resultResponse) {
            component.setResponsePage((Page)new VoidReturnPage(new VoidModel()));
        }
    }
    ,
    REDIRECT_TO_PAGE{

        @Override
        public void handleResults(Component component, ActionResultResponse resultResponse) {
            IsisContext.getTransactionManager().flushTransaction();
            component.setResponsePage((Page)resultResponse.getToPage());
        }
    }
    ,
    SCHEDULE_HANDLER{

        @Override
        public void handleResults(Component component, ActionResultResponse resultResponse) {
            RequestCycle requestCycle = component.getRequestCycle();
            AjaxRequestTarget target = (AjaxRequestTarget)requestCycle.find(AjaxRequestTarget.class);
            if (target == null) {
                requestCycle.scheduleRequestHandlerAfterCurrent(resultResponse.getHandler());
            } else {
                ResourceStreamRequestHandler scheduledHandler = (ResourceStreamRequestHandler)resultResponse.getHandler();
                StreamAfterAjaxResponseBehavior streamingBehavior = new StreamAfterAjaxResponseBehavior(scheduledHandler);
                component.getPage().add(new Behavior[]{streamingBehavior});
                CharSequence callbackUrl = streamingBehavior.getCallbackUrl();
                target.appendJavaScript((CharSequence)("setTimeout(\"window.location.href='" + callbackUrl + "'\", 10);"));
            }
        }
    }
    ,
    OPEN_URL_IN_BROWSER{

        @Override
        public void handleResults(Component component, ActionResultResponse resultResponse) {
            AjaxRequestTarget target = resultResponse.getTarget();
            URL url = resultResponse.getUrl();
            RequestCycle requestCycle = component.getRequestCycle();
            String fullUrl = 4.expanded(requestCycle, url);
            target.appendJavaScript((CharSequence)("setTimeout(function(){Wicket.Event.publish(Isis.Topic.OPEN_IN_NEW_TAB, '" + fullUrl + "');}, 100);"));
        }
    };


    public abstract void handleResults(Component var1, ActionResultResponse var2);

    public static String expanded(RequestCycle requestCycle, URL url) {
        String urlStr = ActionResultResponseHandlingStrategy.expanded(url);
        return requestCycle.getUrlRenderer().renderFullUrl(Url.parse((CharSequence)urlStr));
    }

    public static String expanded(URL url) {
        return ActionResultResponseHandlingStrategy.expanded(url.toString());
    }

    public static String expanded(String urlStr) {
        if (urlStr.contains("antiCache=${currentTimeMillis}")) {
            urlStr = urlStr.replace("antiCache=${currentTimeMillis}", "antiCache=" + System.currentTimeMillis());
        }
        return urlStr;
    }

    private static class StreamAfterAjaxResponseBehavior
    extends AbstractAjaxBehavior {
        private final String fileName;
        private final IResourceStream resourceStream;
        private final Duration cacheDuration;

        public StreamAfterAjaxResponseBehavior(ResourceStreamRequestHandler scheduledHandler) {
            this.fileName = scheduledHandler.getFileName();
            this.resourceStream = scheduledHandler.getResourceStream();
            this.cacheDuration = scheduledHandler.getCacheDuration();
        }

        public void onRequest() {
            ResourceStreamRequestHandler handler = new ResourceStreamRequestHandler(this.resourceStream, this.fileName);
            handler.setCacheDuration(this.cacheDuration);
            handler.setContentDisposition(ContentDisposition.ATTACHMENT);
            Component page = this.getComponent();
            page.getRequestCycle().scheduleRequestHandlerAfterCurrent((IRequestHandler)handler);
            page.remove(new Behavior[]{this});
        }
    }
}

