/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.actionmenu.serviceactions;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.facets.all.describedas.DescribedAsFacet;
import org.apache.isis.core.metamodel.facets.members.cssclassfa.CssClassFaPosition;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.viewer.wicket.model.links.LinkAndLabel;
import org.apache.isis.viewer.wicket.model.mementos.ObjectAdapterMemento;
import org.apache.isis.viewer.wicket.model.models.ActionModel;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.CssClassFaBehavior;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.serviceactions.CssSubMenuItemsPanel;
import org.apache.isis.viewer.wicket.ui.components.widgets.linkandlabel.ActionLinkFactory;
import org.apache.isis.viewer.wicket.ui.util.Components;
import org.apache.isis.viewer.wicket.ui.util.CssClassAppender;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

class CssMenuItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String ID_MENU_LINK = "menuLink";
    private final String name;
    private final List<CssMenuItem> subMenuItems = Lists.newArrayList();
    private CssMenuItem parent;
    private AbstractLink link;
    private boolean enabled = true;
    private String disabledReason;
    private boolean blobOrClob = false;
    private boolean prototype = false;
    private boolean requiresSeparator = false;
    static final String ID_MENU_LABEL = "menuLabel";
    static final String ID_SUB_MENU_ITEMS = "subMenuItems";
    private String actionIdentifier;
    private String cssClass;
    private String cssClassFa;
    private CssClassFaPosition cssClassFaPosition;
    private String description;
    private boolean separator;

    public static Builder newMenuItem(String name) {
        return new Builder(name);
    }

    public void setActionIdentifier(String actionIdentifier) {
        this.actionIdentifier = actionIdentifier;
    }

    public void setPrototyping(boolean prototype) {
        this.prototype = prototype;
    }

    public boolean isPrototyping() {
        return this.prototype;
    }

    public boolean isSeparator() {
        return this.separator;
    }

    public void setSeparator(boolean separator) {
        this.separator = separator;
    }

    public void setRequiresSeparator(boolean requiresSeparator) {
        this.requiresSeparator = requiresSeparator;
    }

    public boolean requiresSeparator() {
        return this.requiresSeparator;
    }

    private CssMenuItem(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    private void setParent(CssMenuItem parent) {
        this.parent = parent;
    }

    public Builder newSubMenuItem(String name) {
        return CssMenuItem.newMenuItem(name).parent(this);
    }

    public List<CssMenuItem> getSubMenuItems() {
        return Collections.unmodifiableList(this.subMenuItems);
    }

    public void replaceSubMenuItems(List<CssMenuItem> menuItems) {
        this.subMenuItems.clear();
        this.subMenuItems.addAll(menuItems);
    }

    public boolean hasSubMenuItems() {
        return this.subMenuItems.size() > 0;
    }

    public AbstractLink getLink() {
        return this.link;
    }

    private void setLink(AbstractLink link) {
        this.link = link;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setReturnsBlobOrClob(boolean blobOrClob) {
        this.blobOrClob = blobOrClob;
    }

    public void setCssClass(String cssClass) {
        this.cssClass = cssClass;
    }

    public String getCssClass() {
        return this.cssClass;
    }

    public void setCssClassFa(String cssClassFa) {
        this.cssClassFa = cssClassFa;
    }

    public String getCssClassFa() {
        return this.cssClassFa;
    }

    public void setCssClassFaPosition(CssClassFaPosition position) {
        this.cssClassFaPosition = position;
    }

    public CssClassFaPosition getCssClassFaPosition() {
        return this.cssClassFaPosition;
    }

    public String getDisabledReason() {
        return this.disabledReason;
    }

    public void setDisabledReason(String disabledReason) {
        this.disabledReason = disabledReason;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Builder newSubMenuItem(ObjectAdapterMemento targetAdapterMemento, ObjectAction objectAction, boolean separator, ActionLinkFactory actionLinkFactory) {
        ObjectAdapter adapter;
        AuthenticationSession session = this.getAuthenticationSession();
        Consent visibility = objectAction.isVisible(session, adapter = targetAdapterMemento.getObjectAdapter(AdapterManager.ConcurrencyChecking.CHECK), ActionModel.WHERE_FOR_ACTION_INVOCATION);
        if (visibility.isVetoed()) {
            return null;
        }
        LinkAndLabel linkAndLabel = actionLinkFactory.newLink(targetAdapterMemento, objectAction, ID_MENU_LINK);
        if (linkAndLabel == null) {
            return null;
        }
        AbstractLink link = linkAndLabel.getLink();
        String actionLabel = linkAndLabel.getLabel();
        Consent usability = objectAction.isUsable(session, adapter, ActionModel.WHERE_FOR_ACTION_INVOCATION);
        String reasonDisabledIfAny = usability.getReason();
        DescribedAsFacet describedAsFacet = (DescribedAsFacet)objectAction.getFacet(DescribedAsFacet.class);
        String descriptionIfAny = describedAsFacet != null ? describedAsFacet.value() : null;
        Builder builder = this.newSubMenuItem(actionLabel).link(link).describedAs(descriptionIfAny).enabled(reasonDisabledIfAny).returnsBlobOrClob(ObjectAction.Utils.returnsBlobOrClob((ObjectAction)objectAction)).prototyping(ObjectAction.Utils.isExplorationOrPrototype((ObjectAction)objectAction)).requiresSeparator(separator).withActionIdentifier(ObjectAction.Utils.actionIdentifierFor((ObjectAction)objectAction)).withCssClass(ObjectAction.Utils.cssClassFor((ObjectAction)objectAction, (ObjectAdapter)adapter)).withCssClassFa(ObjectAction.Utils.cssClassFaFor((ObjectAction)objectAction)).withCssClassFaPosition(ObjectAction.Utils.cssClassFaPositionFor((ObjectAction)objectAction));
        return builder;
    }

    void addTo(MarkupContainer markupContainer) {
        Component menuItemComponent = this.addMenuItemComponentTo(markupContainer);
        this.addSubMenuItemComponentsIfAnyTo(markupContainer);
        this.addCssClassAttributesIfRequired(menuItemComponent);
    }

    private Component addMenuItemComponentTo(MarkupContainer markupContainer) {
        AbstractLink link = this.getLink();
        Label label = new Label(ID_MENU_LABEL, (IModel)Model.of((Serializable)((Object)this.getName())));
        if (link != null) {
            markupContainer.add(new Component[]{link});
            link.add(new Component[]{label});
            if (this.description != null) {
                label.add(new Behavior[]{new AttributeModifier("title", (IModel)Model.of((Serializable)((Object)this.description)))});
            }
            if (this.blobOrClob) {
                link.add(new Behavior[]{new CssClassAppender("noVeil")});
            }
            if (this.prototype) {
                link.add(new Behavior[]{new CssClassAppender("prototype")});
            }
            if (this.cssClass != null) {
                link.add(new Behavior[]{new CssClassAppender(this.cssClass)});
            }
            link.add(new Behavior[]{new CssClassAppender(this.actionIdentifier)});
            String cssClassFa = this.getCssClassFa();
            if (!Strings.isNullOrEmpty((String)cssClassFa)) {
                label.add(new Behavior[]{new CssClassFaBehavior(cssClassFa, this.getCssClassFaPosition())});
            }
            if (!this.isEnabled()) {
                link.add(new Behavior[]{new AttributeModifier("title", (IModel)Model.of((Serializable)((Object)this.getDisabledReason())))});
                link.add(new Behavior[]{new CssClassAppender("disabled")});
                link.setEnabled(false);
            }
            Components.permanentlyHide(markupContainer, ID_MENU_LABEL);
            return link;
        }
        Components.permanentlyHide(markupContainer, ID_MENU_LINK);
        label.add(new Behavior[]{new AttributeModifier("title", (IModel)Model.of((Serializable)((Object)this.getDisabledReason())))});
        label.add(new Behavior[]{new AttributeModifier("class", (IModel)Model.of((Serializable)((Object)"disabled")))});
        markupContainer.add(new Component[]{label});
        return label;
    }

    private void addSubMenuItemComponentsIfAnyTo(MarkupContainer menuItemMarkup) {
        List<CssMenuItem> subMenuItems = this.getSubMenuItems();
        if (subMenuItems.isEmpty()) {
            Components.permanentlyHide(menuItemMarkup, ID_SUB_MENU_ITEMS);
        } else {
            menuItemMarkup.add(new Component[]{new CssSubMenuItemsPanel(ID_SUB_MENU_ITEMS, subMenuItems)});
        }
    }

    private void addCssClassAttributesIfRequired(Component linkComponent) {
        if (!this.hasSubMenuItems()) {
            return;
        }
        if (this.hasParent()) {
            linkComponent.add(new Behavior[]{new CssClassAppender("parent")});
        } else {
            linkComponent.add(new Behavior[]{new CssClassAppender("top-parent")});
        }
    }

    protected AuthenticationSession getAuthenticationSession() {
        return IsisContext.getAuthenticationSession();
    }

    public static class Builder {
        private final CssMenuItem cssMenuItem;

        private Builder(String name) {
            this.cssMenuItem = new CssMenuItem(name);
        }

        public Builder parent(CssMenuItem parent) {
            this.cssMenuItem.setParent(parent);
            return this;
        }

        public <T extends Page> Builder link() {
            SubmitLink link = new SubmitLink(CssMenuItem.ID_MENU_LINK);
            return this.link((AbstractLink)link);
        }

        public <T extends Page> Builder link(AbstractLink link) {
            Ensure.ensureThatArg((Object)link.getId(), (Matcher)CoreMatchers.is((Object)CssMenuItem.ID_MENU_LINK));
            this.cssMenuItem.setLink(link);
            return this;
        }

        public <T extends Page> Builder enabled(String disabledReasonIfAny) {
            this.cssMenuItem.setEnabled(disabledReasonIfAny == null);
            this.cssMenuItem.setDisabledReason(disabledReasonIfAny);
            return this;
        }

        public Builder describedAs(String descriptionIfAny) {
            this.cssMenuItem.setDescription(descriptionIfAny);
            return this;
        }

        public Builder returnsBlobOrClob(boolean blobOrClob) {
            this.cssMenuItem.setReturnsBlobOrClob(blobOrClob);
            return this;
        }

        public Builder prototyping(boolean prototype) {
            this.cssMenuItem.setPrototyping(prototype);
            return this;
        }

        public Builder requiresSeparator(boolean separator) {
            this.cssMenuItem.setRequiresSeparator(separator);
            return this;
        }

        public Builder withActionIdentifier(String actionIdentifier) {
            this.cssMenuItem.setActionIdentifier(actionIdentifier);
            return this;
        }

        public Builder withCssClass(String cssClass) {
            this.cssMenuItem.setCssClass(cssClass);
            return this;
        }

        public Builder withCssClassFa(String cssClassFa) {
            this.cssMenuItem.setCssClassFa(cssClassFa);
            return this;
        }

        public Builder withCssClassFaPosition(CssClassFaPosition position) {
            this.cssMenuItem.setCssClassFaPosition(position);
            return this;
        }

        public CssMenuItem build() {
            if (this.cssMenuItem.parent != null) {
                this.cssMenuItem.parent.subMenuItems.add(this.cssMenuItem);
            }
            return this.cssMenuItem;
        }
    }
}

