/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.viewer.wicket.model.hints.IsisUiHintEvent;
import org.apache.isis.viewer.wicket.model.hints.UiHintContainer;
import org.apache.isis.viewer.wicket.model.hints.UiHintPathSignificant;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.IsisAjaxFallbackHeadersToolbar;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.IsisAjaxNavigationToolbar;
import org.apache.isis.viewer.wicket.ui.util.CssClassAppender;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.extensions.markup.html.repeater.data.table.NoRecordsToolbar;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.repeater.IItemFactory;
import org.apache.wicket.markup.repeater.IItemReuseStrategy;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.OddEvenItem;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.lang.Generics;

public class IsisAjaxFallbackDataTable<T, S>
extends DataTable<T, S>
implements UiHintPathSignificant {
    private static final long serialVersionUID = 1L;
    static final String UIHINT_PAGE_NUMBER = "pageNumber";
    private final ISortableDataProvider<T, S> dataProvider;
    private IsisAjaxFallbackHeadersToolbar<S> headersToolbar;

    public IsisAjaxFallbackDataTable(String id, List<? extends IColumn<T, S>> columns, ISortableDataProvider<T, S> dataProvider, int rowsPerPage) {
        super(id, columns, dataProvider, (long)rowsPerPage);
        this.dataProvider = dataProvider;
        this.setOutputMarkupId(true);
        this.setVersioned(false);
        this.setItemReuseStrategy(new PreserveModelReuseStrategy());
    }

    protected void onInitialize() {
        super.onInitialize();
        this.buildGui();
    }

    private void buildGui() {
        this.headersToolbar = new IsisAjaxFallbackHeadersToolbar(this, this.dataProvider);
        this.addTopToolbar(this.headersToolbar);
        this.addBottomToolbar((AbstractToolbar)new IsisAjaxNavigationToolbar(this));
        this.addBottomToolbar((AbstractToolbar)new NoRecordsToolbar((DataTable)this));
    }

    protected Item<T> newRowItem(String id, int index, final IModel<T> model) {
        return new OddEvenItem<T>(id, index, model){

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                if (model instanceof EntityModel) {
                    EntityModel entityModel = (EntityModel)model;
                    ObjectAdapter objectAdapter = (ObjectAdapter)entityModel.getObject();
                    ObjectSpecification typeOfSpecification = entityModel.getTypeOfSpecification();
                    String cssClass = typeOfSpecification.getCssClass(objectAdapter);
                    CssClassAppender.appendCssClassTo(tag, cssClass);
                }
            }
        };
    }

    public void honourHints() {
        EntityModel uiHintContainer = this.getUiHintContainer();
        if (uiHintContainer == null) {
            return;
        }
        this.headersToolbar.honourSortOrderHints();
        this.honourPageNumberHint((UiHintContainer)uiHintContainer);
    }

    private void honourPageNumberHint(UiHintContainer uiHintContainer) {
        String pageNumberStr = uiHintContainer.getHint((Component)this, UIHINT_PAGE_NUMBER);
        if (pageNumberStr != null) {
            try {
                long pageNumber = Long.parseLong(pageNumberStr);
                if (pageNumber >= 0L) {
                    this.setCurrentPage(pageNumber);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        uiHintContainer.setHint((Component)this, UIHINT_PAGE_NUMBER, "" + this.getCurrentPage());
    }

    public void setPageNumberHintAndBroadcast(AjaxRequestTarget target) {
        EntityModel uiHintContainer = this.getUiHintContainer();
        if (uiHintContainer == null) {
            return;
        }
        uiHintContainer.setHint((Component)this, UIHINT_PAGE_NUMBER, "" + this.getCurrentPage());
        this.send((IEventSink)this.getPage(), Broadcast.EXACT, new IsisUiHintEvent((UiHintContainer)uiHintContainer, target));
    }

    public void setSortOrderHintAndBroadcast(SortOrder order, String property, AjaxRequestTarget target) {
        EntityModel uiHintContainer = this.getUiHintContainer();
        if (uiHintContainer == null) {
            return;
        }
        for (SortOrder eachSortOrder : SortOrder.values()) {
            uiHintContainer.clearHint((Component)this, eachSortOrder.name());
        }
        uiHintContainer.setHint((Component)this, order.name(), property);
        this.send((IEventSink)this.getPage(), Broadcast.EXACT, new IsisUiHintEvent((UiHintContainer)uiHintContainer, target));
    }

    private EntityModel getUiHintContainer() {
        return (EntityModel)UiHintContainer.Util.hintContainerOf((Component)this, EntityModel.class);
    }

    static class PreserveModelReuseStrategy
    implements IItemReuseStrategy {
        private static final long serialVersionUID = 1L;
        private static IItemReuseStrategy instance = new PreserveModelReuseStrategy();

        PreserveModelReuseStrategy() {
        }

        public static IItemReuseStrategy getInstance() {
            return instance;
        }

        public <T> Iterator<Item<T>> getItems(final IItemFactory<T> factory, final Iterator<IModel<T>> newModels, Iterator<Item<T>> existingItems) {
            final HashMap modelToItem = Generics.newHashMap();
            while (existingItems.hasNext()) {
                Item<T> item = existingItems.next();
                modelToItem.put(item.getModel(), item);
            }
            return new Iterator<Item<T>>(){
                private int index = 0;

                @Override
                public boolean hasNext() {
                    return newModels.hasNext();
                }

                @Override
                public Item<T> next() {
                    IModel model = (IModel)newModels.next();
                    Item oldItem = (Item)modelToItem.get(model);
                    IModel model2 = oldItem != null ? oldItem.getModel() : model;
                    return factory.newItem(this.index++, model2);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

