/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars.jdkdates;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettings;
import org.apache.isis.viewer.wicket.ui.components.scalars.jdkdates.DateConverterForJavaAbstract;
import org.apache.wicket.util.convert.ConversionException;

public class DateConverterForJavaUtilDate
extends DateConverterForJavaAbstract<Date> {
    private static final long serialVersionUID = 1L;

    public DateConverterForJavaUtilDate(WicketViewerSettings settings, int adjustBy) {
        this(settings.getDatePattern(), settings.getDateTimePattern(), settings.getDateTimePattern(), adjustBy);
    }

    public DateConverterForJavaUtilDate(String datePattern, String dateTimePattern, String datePickerPattern, int adjustBy) {
        super(Date.class, datePattern, dateTimePattern, datePickerPattern, adjustBy);
    }

    @Override
    protected Date doConvertToObject(String value, Locale locale) throws ConversionException {
        Date date = this.convert(value);
        Date adjustedDate = DateConverterForJavaUtilDate.addDays(date, 0 - this.adjustBy);
        return adjustedDate;
    }

    private Date convert(String valueStr) {
        try {
            return this.newSimpleDateFormatUsingDateTimePattern().parse(valueStr);
        }
        catch (ParseException ex) {
            try {
                return this.newSimpleDateFormatUsingDatePattern().parse(valueStr);
            }
            catch (ParseException ex2) {
                throw new ConversionException("Value cannot be converted as a date/time", (Throwable)ex);
            }
        }
    }

    @Override
    protected String doConvertToString(Date value, Locale locale) throws ConversionException {
        Date adjustedDate = DateConverterForJavaUtilDate.addDays(value, this.adjustBy);
        return this.newSimpleDateFormatUsingDateTimePattern().format(adjustedDate);
    }

    private static Date addDays(Date value, int days) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(value);
        cal.add(5, days);
        Date adjusted = cal.getTime();
        return adjusted;
    }
}

