/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars.jodatime;

import java.util.Locale;
import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettings;
import org.apache.isis.viewer.wicket.ui.components.scalars.jodatime.DateConverterForJodaAbstract;
import org.apache.wicket.util.convert.ConversionException;
import org.joda.time.DateTime;

public class DateConverterForJodaDateTime
extends DateConverterForJodaAbstract<DateTime> {
    private static final long serialVersionUID = 1L;

    public DateConverterForJodaDateTime(WicketViewerSettings settings, int adjustBy) {
        this(settings.getDatePattern(), settings.getDateTimePattern(), settings.getDateTimePattern(), adjustBy);
    }

    private DateConverterForJodaDateTime(String datePattern, String dateTimePattern, String datePickerPattern, int adjustBy) {
        super(DateTime.class, datePattern, dateTimePattern, datePickerPattern, adjustBy);
    }

    @Override
    protected DateTime doConvertToObject(String value, Locale locale) throws ConversionException {
        DateTime parsedDateTime = this.convert(value);
        return parsedDateTime.minusDays(this.adjustBy);
    }

    private DateTime convert(String value) throws ConversionException {
        try {
            return this.getFormatterForDateTimePattern().parseDateTime(value);
        }
        catch (IllegalArgumentException ex) {
            try {
                return this.getFormatterForDatePattern().parseDateTime(value);
            }
            catch (IllegalArgumentException ex2) {
                throw new ConversionException("Cannot convert into a date/time", (Throwable)ex2);
            }
        }
    }

    @Override
    protected String doConvertToString(DateTime value, Locale locale) {
        return value.plusDays(this.adjustBy).toString(this.getFormatterForDateTimePattern());
    }
}

