/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.widgets.bootstrap;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.behavior.Draggable;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.behavior.DraggableConfig;
import java.io.Serializable;
import org.apache.isis.viewer.wicket.model.models.ActionPrompt;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;

public class ModalDialog<T>
extends Modal<T>
implements ActionPrompt {
    public ModalDialog(String markupId) {
        this(markupId, null);
    }

    public ModalDialog(String id, IModel<T> model) {
        super(id, model);
        this.setFadeIn(false);
        this.setUseKeyboard(true);
        this.setDisableEnforceFocus(true);
        this.setOutputMarkupPlaceholderTag(true);
        WebMarkupContainer emptyComponent = new WebMarkupContainer(this.getContentId());
        this.add(new Component[]{emptyComponent});
    }

    public void setTitle(Component component, AjaxRequestTarget target) {
        ((MarkupContainer)this.get("dialog:header")).addOrReplace(new Component[]{component});
    }

    public void setPanel(Component component, AjaxRequestTarget target) {
        this.addOrReplace(new Component[]{component});
    }

    public void showPrompt(AjaxRequestTarget target) {
        this.setVisible(true);
        target.add(new Component[]{this});
        this.show(target);
    }

    public String getTitleId() {
        return "header-label";
    }

    public String getContentId() {
        return "content";
    }

    public void closePrompt(AjaxRequestTarget target) {
        if (target != null) {
            this.close(target);
        }
        this.setVisible(false);
    }

    protected WebMarkupContainer createDialog(String id) {
        WebMarkupContainer dialog = super.createDialog(id);
        dialog.add(new Behavior[]{AttributeAppender.append((String)"class", (Serializable)((Object)"modal-dialog-center"))});
        dialog.add(new Behavior[]{new Draggable(new DraggableConfig().withHandle(".modal-header").withCursor("move"))});
        return dialog;
    }
}

