/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.widgets.breadcrumbs;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.isis.viewer.wicket.model.mementos.PageParameterNames;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class BreadcrumbModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int MAX_SIZE = 5;
    private final Map<String, EntityModel> entityModelByOidStr = Maps.newHashMap();
    private final Map<EntityModel, String> titleByEntityModel = Maps.newHashMap();
    private final Map<EntityModel, String> oidStrByEntityModel = Maps.newHashMap();
    private final List<EntityModel> list = Lists.newArrayList();

    public List<EntityModel> getList() {
        return Collections.unmodifiableList(this.list);
    }

    public void visited(EntityModel entityModel) {
        if (entityModel.getTypeOfSpecification().isViewModel()) {
            return;
        }
        String oidStr = this.oidStrFor(entityModel);
        this.removeExisting(oidStr);
        this.addToStart(oidStr, entityModel);
        this.trimTo(5);
    }

    private String oidStrFor(EntityModel entityModel) {
        PageParameters pageParameters = entityModel.getPageParametersWithoutUiHints();
        return PageParameterNames.OBJECT_OID.getStringFrom(pageParameters);
    }

    private void addToStart(String oidStr, EntityModel entityModel) {
        this.entityModelByOidStr.put(oidStr, entityModel);
        this.titleByEntityModel.put(entityModel, entityModel.getTitle());
        this.oidStrByEntityModel.put(entityModel, oidStr);
        this.list.add(0, entityModel);
    }

    private void removeExisting(String oidStr) {
        EntityModel existingModel = this.entityModelByOidStr.get(oidStr);
        if (existingModel != null) {
            this.remove(oidStr, existingModel);
        }
    }

    private void trimTo(int size) {
        if (this.list.size() <= size) {
            return;
        }
        List<EntityModel> modelsToRemove = this.list.subList(size, this.list.size());
        for (EntityModel model : modelsToRemove) {
            String oidStr = this.oidStrByEntityModel.get(model);
            this.remove(oidStr, model);
        }
    }

    private void remove(String oidStr, EntityModel model) {
        this.entityModelByOidStr.remove(oidStr);
        this.titleByEntityModel.remove(model);
        this.oidStrByEntityModel.remove(model);
        this.list.remove(model);
    }

    public void remove(String oidStr) {
        EntityModel removedModel = this.entityModelByOidStr.remove(oidStr);
        if (removedModel != null) {
            this.remove(removedModel);
        }
    }

    public void remove(EntityModel entityModel) {
        String oidStr = this.oidStrByEntityModel.get(entityModel);
        if (oidStr != null) {
            this.remove(oidStr, entityModel);
        }
    }

    public String titleFor(EntityModel model) {
        return this.titleByEntityModel.get(model);
    }

    public EntityModel lookup(String oidStr) {
        if (oidStr == null) {
            return null;
        }
        return this.entityModelByOidStr.get(oidStr);
    }
}

