/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.widgets.linkandlabel;

import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import java.net.URL;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.applib.value.Blob;
import org.apache.isis.applib.value.Clob;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facets.members.cssclassfa.CssClassFaPosition;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.viewer.wicket.model.links.LinkAndLabel;
import org.apache.isis.viewer.wicket.model.models.ActionModel;
import org.apache.isis.viewer.wicket.model.models.ActionPrompt;
import org.apache.isis.viewer.wicket.model.models.ActionPromptProvider;
import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.isis.viewer.wicket.ui.app.registry.ComponentFactoryRegistry;
import org.apache.isis.viewer.wicket.ui.app.registry.ComponentFactoryRegistryAccessor;
import org.apache.isis.viewer.wicket.ui.components.actionprompt.ActionPromptHeaderPanel;
import org.apache.isis.viewer.wicket.ui.components.actions.ActionPanel;
import org.apache.isis.viewer.wicket.ui.components.widgets.linkandlabel.ActionLinkFactory;
import org.apache.isis.viewer.wicket.ui.components.widgets.linkandlabel.AjaxDeferredBehaviour;
import org.apache.isis.viewer.wicket.ui.pages.PageClassRegistry;
import org.apache.isis.viewer.wicket.ui.pages.PageClassRegistryAccessor;
import org.apache.isis.viewer.wicket.ui.util.CssClassAppender;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.IRequestHandler;

public abstract class ActionLinkFactoryAbstract
implements ActionLinkFactory {
    private static final long serialVersionUID = 1L;

    protected AbstractLink newLink(String linkId, ObjectAdapter objectAdapter, ObjectAction action) {
        final ActionModel actionModel = ActionModel.create((ObjectAdapter)objectAdapter, (ObjectAction)action);
        final AjaxDeferredBehaviour ajaxDeferredBehaviour = ActionLinkFactoryAbstract.determineDeferredBehaviour(action, actionModel);
        AjaxLink<Object> link = new AjaxLink<Object>(linkId){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                if (ajaxDeferredBehaviour != null) {
                    ajaxDeferredBehaviour.initiate(target);
                } else {
                    ActionPromptProvider promptProvider = ActionPromptProvider.Util.getFrom((Page)this.getPage());
                    ActionPrompt actionPrompt = promptProvider.getActionPrompt();
                    ActionPromptHeaderPanel titlePanel = new ActionPromptHeaderPanel(actionPrompt.getTitleId(), actionModel);
                    ActionPanel actionPanel = (ActionPanel)ActionLinkFactoryAbstract.this.getComponentFactoryRegistry().createComponent(ComponentType.ACTION_PROMPT, actionPrompt.getContentId(), (IModel<?>)actionModel);
                    actionPanel.setShowHeader(false);
                    actionPrompt.setTitle((Component)titlePanel, target);
                    actionPrompt.setPanel((Component)actionPanel, target);
                    actionPanel.setActionPrompt(actionPrompt);
                    actionPrompt.showPrompt(target);
                }
            }

            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                super.updateAjaxAttributes(attributes);
                attributes.setEventPropagation(AjaxRequestAttributes.EventPropagation.BUBBLE);
            }

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                Buttons.fixDisabledState((Component)this, (ComponentTag)tag);
            }
        };
        if (ajaxDeferredBehaviour != null) {
            link.add(new Behavior[]{ajaxDeferredBehaviour});
        }
        link.add(new Behavior[]{new CssClassAppender("noVeil")});
        return link;
    }

    private static AjaxDeferredBehaviour determineDeferredBehaviour(ObjectAction action, final ActionModel actionModel) {
        if (ActionLinkFactoryAbstract.isNoArgReturnTypeRedirect(action)) {
            return new AjaxDeferredBehaviour(AjaxDeferredBehaviour.OpenUrlStrategy.NEW_WINDOW){
                private static final long serialVersionUID = 1L;

                @Override
                protected IRequestHandler getRequestHandler() {
                    ObjectAdapter resultAdapter = actionModel.executeHandlingApplicationExceptions();
                    Object value = resultAdapter.getObject();
                    return ActionModel.redirectHandler((Object)value);
                }
            };
        }
        if (ActionLinkFactoryAbstract.isNoArgReturnTypeDownload(action)) {
            return new AjaxDeferredBehaviour(AjaxDeferredBehaviour.OpenUrlStrategy.SAME_WINDOW){
                private static final long serialVersionUID = 1L;

                @Override
                protected IRequestHandler getRequestHandler() {
                    ObjectAdapter resultAdapter = actionModel.executeHandlingApplicationExceptions();
                    Object value = resultAdapter.getObject();
                    return ActionModel.downloadHandler((Object)value);
                }
            };
        }
        return null;
    }

    private static boolean isNoArgReturnTypeRedirect(ObjectAction action) {
        return action.getParameterCount() == 0 && action.getReturnType() != null && action.getReturnType().getCorrespondingClass() == URL.class;
    }

    private static boolean isNoArgReturnTypeDownload(ObjectAction action) {
        return action.getParameterCount() == 0 && action.getReturnType() != null && (action.getReturnType().getCorrespondingClass() == Blob.class || action.getReturnType().getCorrespondingClass() == Clob.class);
    }

    protected LinkAndLabel newLinkAndLabel(ObjectAdapter objectAdapter, ObjectAction objectAction, AbstractLink link, String disabledReasonIfAny) {
        String label = ObjectAction.Utils.nameFor((ObjectAction)objectAction);
        boolean blobOrClob = ObjectAction.Utils.returnsBlobOrClob((ObjectAction)objectAction);
        boolean prototype = ObjectAction.Utils.isExplorationOrPrototype((ObjectAction)objectAction);
        String actionIdentifier = ObjectAction.Utils.actionIdentifierFor((ObjectAction)objectAction);
        String description = ObjectAction.Utils.descriptionOf((ObjectAction)objectAction);
        ActionLayout.Position position = ObjectAction.Utils.actionLayoutPositionOf((ObjectAction)objectAction);
        String cssClass = ObjectAction.Utils.cssClassFor((ObjectAction)objectAction, (ObjectAdapter)objectAdapter);
        String cssClassFa = ObjectAction.Utils.cssClassFaFor((ObjectAction)objectAction);
        CssClassFaPosition cssClassFaPosition = ObjectAction.Utils.cssClassFaPositionFor((ObjectAction)objectAction);
        return new LinkAndLabel(link, label, disabledReasonIfAny, description, blobOrClob, prototype, actionIdentifier, cssClass, cssClassFa, cssClassFaPosition, position);
    }

    protected ComponentFactoryRegistry getComponentFactoryRegistry() {
        return ((ComponentFactoryRegistryAccessor)Application.get()).getComponentFactoryRegistry();
    }

    protected PageClassRegistry getPageClassRegistry() {
        return ((PageClassRegistryAccessor)Application.get()).getPageClassRegistry();
    }
}

