/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency.analyze;

import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalysis;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalyzer;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalyzerException;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAnalyzeMojo
extends AbstractMojo
implements Contextualizable {
    private Context context;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="analyzer", defaultValue="default")
    private String analyzer;
    @Parameter(property="failOnWarning", defaultValue="false")
    private boolean failOnWarning;
    @Parameter(property="verbose", defaultValue="false")
    private boolean verbose;
    @Parameter(property="ignoreNonCompile", defaultValue="false")
    private boolean ignoreNonCompile;
    @Parameter(property="outputXML", defaultValue="false")
    private boolean outputXML;
    @Parameter(property="scriptableOutput", defaultValue="false")
    private boolean scriptableOutput;
    @Parameter(property="scriptableFlag", defaultValue="$$$%%%")
    private String scriptableFlag;
    @Parameter(defaultValue="${basedir}", readonly=true)
    private File baseDir;
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    private File outputDirectory;
    @Parameter
    private String[] usedDependencies;
    @Parameter(property="mdep.analyze.skip", defaultValue="false")
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkip()) {
            this.getLog().info((CharSequence)"Skipping plugin execution");
            return;
        }
        if ("pom".equals(this.project.getPackaging())) {
            this.getLog().info((CharSequence)"Skipping pom project");
            return;
        }
        if (this.outputDirectory == null || !this.outputDirectory.exists()) {
            this.getLog().info((CharSequence)"Skipping project with no build directory");
            return;
        }
        boolean warning = this.checkDependencies();
        if (warning && this.failOnWarning) {
            throw new MojoExecutionException("Dependency problems found");
        }
    }

    protected ProjectDependencyAnalyzer createProjectDependencyAnalyzer() throws MojoExecutionException {
        String role = ProjectDependencyAnalyzer.ROLE;
        String roleHint = this.analyzer;
        try {
            PlexusContainer container = (PlexusContainer)this.context.get((Object)"plexus");
            return (ProjectDependencyAnalyzer)container.lookup(role, roleHint);
        }
        catch (Exception exception) {
            throw new MojoExecutionException("Failed to instantiate ProjectDependencyAnalyser with role " + role + " / role-hint " + roleHint, exception);
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.context = context;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    private boolean checkDependencies() throws MojoExecutionException {
        ProjectDependencyAnalysis analysis;
        try {
            analysis = this.createProjectDependencyAnalyzer().analyze(this.project);
            if (this.usedDependencies != null) {
                analysis = analysis.forceDeclaredDependenciesUsage(this.usedDependencies);
            }
        }
        catch (ProjectDependencyAnalyzerException exception) {
            throw new MojoExecutionException("Cannot analyze dependencies", (Exception)((Object)exception));
        }
        if (this.ignoreNonCompile) {
            analysis = analysis.ignoreNonCompile();
        }
        Set usedDeclared = analysis.getUsedDeclaredArtifacts();
        Set usedUndeclared = analysis.getUsedUndeclaredArtifacts();
        Set unusedDeclared = analysis.getUnusedDeclaredArtifacts();
        if ((!this.verbose || usedDeclared.isEmpty()) && usedUndeclared.isEmpty() && unusedDeclared.isEmpty()) {
            this.getLog().info((CharSequence)"No dependency problems found");
            return false;
        }
        if (this.verbose && !usedDeclared.isEmpty()) {
            this.getLog().info((CharSequence)"Used declared dependencies found:");
            this.logArtifacts(analysis.getUsedDeclaredArtifacts(), false);
        }
        if (!usedUndeclared.isEmpty()) {
            this.getLog().warn((CharSequence)"Used undeclared dependencies found:");
            this.logArtifacts(usedUndeclared, true);
        }
        if (!unusedDeclared.isEmpty()) {
            this.getLog().warn((CharSequence)"Unused declared dependencies found:");
            this.logArtifacts(unusedDeclared, true);
        }
        if (this.outputXML) {
            this.writeDependencyXML(usedUndeclared);
        }
        if (this.scriptableOutput) {
            this.writeScriptableOutput(usedUndeclared);
        }
        return !usedUndeclared.isEmpty() || !unusedDeclared.isEmpty();
    }

    private void logArtifacts(Set<Artifact> artifacts, boolean warn) {
        if (artifacts.isEmpty()) {
            this.getLog().info((CharSequence)"   None");
        } else {
            for (Artifact artifact : artifacts) {
                artifact.isSnapshot();
                if (warn) {
                    this.getLog().warn((CharSequence)("   " + artifact));
                    continue;
                }
                this.getLog().info((CharSequence)("   " + artifact));
            }
        }
    }

    private void writeDependencyXML(Set<Artifact> artifacts) {
        if (!artifacts.isEmpty()) {
            this.getLog().info((CharSequence)"Add the following to your pom to correct the missing dependencies: ");
            StringWriter out = new StringWriter();
            PrettyPrintXMLWriter writer = new PrettyPrintXMLWriter((Writer)out);
            for (Artifact artifact : artifacts) {
                artifact.isSnapshot();
                writer.startElement("dependency");
                writer.startElement("groupId");
                writer.writeText(artifact.getGroupId());
                writer.endElement();
                writer.startElement("artifactId");
                writer.writeText(artifact.getArtifactId());
                writer.endElement();
                writer.startElement("version");
                writer.writeText(artifact.getBaseVersion());
                if (!StringUtils.isBlank((String)artifact.getClassifier())) {
                    writer.startElement("classifier");
                    writer.writeText(artifact.getClassifier());
                    writer.endElement();
                }
                writer.endElement();
                if (!"compile".equals(artifact.getScope())) {
                    writer.startElement("scope");
                    writer.writeText(artifact.getScope());
                    writer.endElement();
                }
                writer.endElement();
            }
            this.getLog().info((CharSequence)("\n" + out.getBuffer()));
        }
    }

    private void writeScriptableOutput(Set<Artifact> artifacts) {
        if (!artifacts.isEmpty()) {
            this.getLog().info((CharSequence)"Missing dependencies: ");
            String pomFile = this.baseDir.getAbsolutePath() + File.separatorChar + "pom.xml";
            StringBuilder buf = new StringBuilder();
            for (Artifact artifact : artifacts) {
                artifact.isSnapshot();
                buf.append(this.scriptableFlag).append(":").append(pomFile).append(":").append(artifact.getDependencyConflictId()).append(":").append(artifact.getClassifier()).append(":").append(artifact.getBaseVersion()).append(":").append(artifact.getScope()).append("\n");
            }
            this.getLog().info((CharSequence)("\n" + buf));
        }
    }
}

