/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.jar.identification.exposers;

import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.maven.shared.jar.JarAnalyzer;
import org.apache.maven.shared.jar.identification.JarIdentification;
import org.apache.maven.shared.jar.identification.JarIdentificationExposer;

public class ManifestExposer
implements JarIdentificationExposer {
    public void expose(JarIdentification identification, JarAnalyzer jarAnalyzer) {
        Manifest manifest = jarAnalyzer.getJarData().getManifest();
        if (manifest != null) {
            this.addManifestAttributeValues(manifest.getMainAttributes(), identification);
            Map<String, Attributes> entries = manifest.getEntries();
            for (Map.Entry<String, Attributes> entry : entries.entrySet()) {
                Attributes attribs = entry.getValue();
                this.addManifestAttributeValues(attribs, identification);
            }
        }
    }

    private void addManifestAttributeValues(Attributes attribs, JarIdentification identification) {
        identification.addName(attribs.getValue(Attributes.Name.IMPLEMENTATION_TITLE));
        identification.addVersion(attribs.getValue(Attributes.Name.IMPLEMENTATION_VERSION));
        identification.addVendor(attribs.getValue(Attributes.Name.IMPLEMENTATION_VENDOR));
        identification.addName(attribs.getValue(Attributes.Name.SPECIFICATION_TITLE));
        identification.addVersion(attribs.getValue(Attributes.Name.SPECIFICATION_VERSION));
        identification.addVendor(attribs.getValue(Attributes.Name.SPECIFICATION_VENDOR));
        identification.addGroupId(attribs.getValue(Attributes.Name.EXTENSION_NAME));
    }
}

