/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.http;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.shared.http.AbstractHttpClientWagon;
import org.apache.maven.wagon.shared.http.HtmlFileListParser;
import org.apache.maven.wagon.shared.http.HttpMessageUtils;

public class HttpWagon
extends AbstractHttpClientWagon {
    public List<String> getFileList(String destinationDirectory) throws AuthorizationException, ResourceDoesNotExistException, TransferFailedException {
        return this.getFileList(this.getInitialBackoffSeconds(), destinationDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> getFileList(int wait, String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        if (destinationDirectory.length() > 0 && !destinationDirectory.endsWith("/")) {
            destinationDirectory = destinationDirectory + "/";
        }
        String url = this.getRepository().getUrl() + "/" + destinationDirectory;
        HttpGet getMethod = new HttpGet(url);
        try (CloseableHttpResponse response = this.execute((HttpUriRequest)getMethod);){
            String reasonPhrase = response.getStatusLine().getReasonPhrase();
            int statusCode = response.getStatusLine().getStatusCode();
            this.fireTransferDebug(HttpMessageUtils.formatTransferDebugMessage((String)url, (int)statusCode, (String)reasonPhrase, (ProxyInfo)this.getProxyInfo()));
            switch (statusCode) {
                case 200: {
                    break;
                }
                case 401: 
                case 403: 
                case 407: {
                    throw new AuthorizationException(HttpMessageUtils.formatAuthorizationMessage((String)url, (int)statusCode, (String)reasonPhrase, (ProxyInfo)this.getProxyInfo()));
                }
                case 404: {
                    throw new ResourceDoesNotExistException(HttpMessageUtils.formatResourceDoesNotExistMessage((String)url, (int)statusCode, (String)reasonPhrase, (ProxyInfo)this.getProxyInfo()));
                }
                case 429: {
                    List<String> list = this.getFileList(this.backoff(wait, url), destinationDirectory);
                    return list;
                }
                default: {
                    throw new TransferFailedException(HttpMessageUtils.formatTransferFailedMessage((String)url, (int)statusCode, (String)reasonPhrase, (ProxyInfo)this.getProxyInfo()));
                }
            }
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                List list = HtmlFileListParser.parseFileList((String)url, (InputStream)entity.getContent());
                return list;
            }
            List<String> list = Collections.emptyList();
            return list;
        }
        catch (IOException e) {
            throw new TransferFailedException("Could not read response body.", (Throwable)e);
        }
        catch (HttpException e) {
            throw new TransferFailedException("Could not read response body.", (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new TransferFailedException("Unable to wait for resource.", (Throwable)e);
        }
    }
}

