/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.webdav;

import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.client.methods.HttpPropfind;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.maven.wagon.PathUtils;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.providers.webdav.PathNavigator;
import org.apache.maven.wagon.repository.Repository;
import org.apache.maven.wagon.shared.http.AbstractHttpClientWagon;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.w3c.dom.Node;

public class WebDavWagon
extends AbstractHttpClientWagon {
    protected static final String CONTINUE_ON_FAILURE_PROPERTY = "wagon.webdav.continueOnFailure";
    private final boolean continueOnFailure = Boolean.getBoolean("wagon.webdav.continueOnFailure");
    private static final String[][] PROTOCOL_MAP = new String[][]{{"dav:http://", "http://"}, {"dav:https://", "https://"}, {"dav+http://", "http://"}, {"dav+https://", "https://"}, {"dav://", "http://"}, {"davs://", "https://"}};

    public boolean supportsDirectoryCopy() {
        return true;
    }

    protected void mkdirs(String dir) throws IOException {
        String url;
        Repository repository = this.getRepository();
        String basedir = repository.getBasedir();
        String baseUrl = repository.getProtocol() + "://" + repository.getHost();
        if (repository.getPort() != -1) {
            baseUrl = baseUrl + ":" + repository.getPort();
        }
        String relpath = FileUtils.normalize((String)(WebDavWagon.getPath((String)basedir, (String)dir) + "/"));
        PathNavigator navigator = new PathNavigator(relpath);
        int status = -1;
        while ((status = this.doMkCol(url = baseUrl + "/" + navigator.getPath())) != 201 && status != 405 && navigator.backward()) {
        }
        while (navigator.forward()) {
            url = baseUrl + "/" + navigator.getPath();
            status = this.doMkCol(url);
            if (status == 201) continue;
            throw new IOException("Unable to create collection: " + url + "; status code = " + status);
        }
    }

    /*
     * Exception decompiling
     */
    private int doMkCol(String url) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void putDirectory(File sourceDirectory, String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        for (File file : sourceDirectory.listFiles()) {
            if (file.isDirectory()) {
                this.putDirectory(file, destinationDirectory + "/" + file.getName());
                continue;
            }
            String target = destinationDirectory + "/" + file.getName();
            this.put(file, target);
        }
    }

    private boolean isDirectory(String url) throws IOException, DavException {
        DavPropertyNameSet nameSet = new DavPropertyNameSet();
        nameSet.add(DavPropertyName.create((String)"resourcetype"));
        CloseableHttpResponse closeableHttpResponse = null;
        HttpPropfind method = null;
        try {
            MultiStatus multiStatus22;
            MultiStatusResponse response;
            DavPropertySet propertySet;
            DavProperty property;
            method = new HttpPropfind(url, nameSet, 0);
            closeableHttpResponse = this.execute((HttpUriRequest)method);
            if (method.succeeded((HttpResponse)closeableHttpResponse) && (property = (propertySet = (response = (multiStatus22 = method.getResponseBodyAsMultiStatus((HttpResponse)closeableHttpResponse)).getResponses()[0]).getProperties(200)).get("resourcetype")) != null) {
                Node node = (Node)property.getValue();
                boolean bl = node.getLocalName().equals("collection");
                return bl;
            }
            boolean multiStatus22 = false;
            return multiStatus22;
        }
        catch (HttpException e) {
            throw new IOException(e.getMessage(), e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
            if (closeableHttpResponse != null) {
                closeableHttpResponse.close();
            }
        }
    }

    public List<String> getFileList(String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        String repositoryUrl = this.repository.getUrl();
        String url = repositoryUrl + (repositoryUrl.endsWith("/") ? "" : "/") + destinationDirectory;
        HttpPropfind method = null;
        CloseableHttpResponse closeableHttpResponse = null;
        try {
            if (this.isDirectory(url)) {
                DavPropertyNameSet nameSet = new DavPropertyNameSet();
                nameSet.add(DavPropertyName.create((String)"displayname"));
                method = new HttpPropfind(url, nameSet, 1);
                closeableHttpResponse = this.execute((HttpUriRequest)method);
                if (method.succeeded((HttpResponse)closeableHttpResponse)) {
                    ArrayList<String> dirs = new ArrayList<String>();
                    MultiStatus multiStatus = method.getResponseBodyAsMultiStatus((HttpResponse)closeableHttpResponse);
                    for (int i = 0; i < multiStatus.getResponses().length; ++i) {
                        MultiStatusResponse response = multiStatus.getResponses()[i];
                        String entryUrl = response.getHref();
                        String fileName = PathUtils.filename((String)URLDecoder.decode(entryUrl));
                        if (entryUrl.endsWith("/")) {
                            if (i == 0) continue;
                            fileName = PathUtils.filename((String)PathUtils.dirname((String)URLDecoder.decode(entryUrl))) + "/";
                        }
                        if (StringUtils.isEmpty((String)fileName)) continue;
                        dirs.add(fileName);
                    }
                    ArrayList<String> arrayList = dirs;
                    return arrayList;
                }
                if (closeableHttpResponse.getStatusLine().getStatusCode() == 404) {
                    throw new ResourceDoesNotExistException("Destination directory does not exist: " + url);
                }
            }
        }
        catch (HttpException e) {
            throw new TransferFailedException(e.getMessage(), (Throwable)e);
        }
        catch (DavException e) {
            throw new TransferFailedException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new TransferFailedException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
            if (closeableHttpResponse != null) {
                try {
                    closeableHttpResponse.close();
                }
                catch (IOException iOException) {}
            }
        }
        throw new ResourceDoesNotExistException("Destination path exists but is not a WebDAV collection (directory): " + url);
    }

    public String getURL(Repository repository) {
        String url = repository.getUrl();
        for (String[] entry : PROTOCOL_MAP) {
            String protocol = entry[0];
            if (!url.startsWith(protocol)) continue;
            return entry[1] + url.substring(protocol.length());
        }
        return url;
    }

    public void put(File source, String resourceName) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        try {
            super.put(source, resourceName);
        }
        catch (TransferFailedException e) {
            if (this.continueOnFailure) {
                System.out.println("WARN: Skip unable to transfer '" + resourceName + "' from '" + source.getPath() + "' due to " + e.getMessage());
            }
            throw e;
        }
    }
}

