/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.request.locale;

import java.util.Locale;
import org.apache.tiles.request.ApplicationResource;

public abstract class PostfixedApplicationResource
implements ApplicationResource {
    private String pathPrefix;
    private String suffix;
    private Locale locale;

    protected PostfixedApplicationResource(String localePath) {
        int prefixIndex = localePath.indexOf(95, localePath.lastIndexOf("/"));
        int suffixIndex = localePath.lastIndexOf(46);
        if (suffixIndex < 0) {
            this.suffix = "";
            suffixIndex = localePath.length();
        } else {
            this.suffix = localePath.substring(suffixIndex);
        }
        if (prefixIndex < 0) {
            this.pathPrefix = localePath.substring(0, suffixIndex);
            this.locale = Locale.ROOT;
        } else {
            int variantIndex;
            this.pathPrefix = localePath.substring(0, prefixIndex);
            String localeString = localePath.substring(prefixIndex + 1, suffixIndex);
            int countryIndex = localeString.indexOf(95);
            this.locale = countryIndex < 0 ? new Locale(localeString) : ((variantIndex = localeString.indexOf(95, countryIndex + 1)) < 0 ? new Locale(localeString.substring(0, countryIndex), localeString.substring(countryIndex + 1)) : new Locale(localeString.substring(0, countryIndex), localeString.substring(countryIndex + 1, variantIndex), localeString.substring(variantIndex + 1)));
        }
    }

    protected PostfixedApplicationResource(String path, Locale locale) {
        int suffixIndex = path.lastIndexOf(46);
        if (suffixIndex < 0) {
            this.suffix = "";
            this.pathPrefix = path;
        } else {
            this.pathPrefix = path.substring(0, suffixIndex);
            this.suffix = path.substring(suffixIndex);
        }
        this.locale = locale;
    }

    @Override
    public final String getLocalePath() {
        return this.getLocalePath(this.locale);
    }

    @Override
    public final String getPath() {
        return this.pathPrefix + this.suffix;
    }

    @Override
    public final String getLocalePath(Locale newLocale) {
        return this.pathPrefix + PostfixedApplicationResource.getPostfix(newLocale) + this.suffix;
    }

    private static final String getPostfix(Locale locale) {
        if (locale == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        if (!"".equals(language)) {
            builder.append("_");
            builder.append(language);
            if (!"".equals(country)) {
                builder.append("_");
                builder.append(country);
                if (!"".equals(variant)) {
                    builder.append("_");
                    builder.append(variant);
                }
            }
        }
        return builder.toString();
    }

    @Override
    public final Locale getLocale() {
        return this.locale;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.locale == null ? 0 : this.locale.hashCode());
        result = 31 * result + (this.pathPrefix == null ? 0 : this.pathPrefix.hashCode());
        result = 31 * result + (this.suffix == null ? 0 : this.suffix.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PostfixedApplicationResource other = (PostfixedApplicationResource)obj;
        if (this.locale == null ? other.locale != null : !this.locale.equals(other.locale)) {
            return false;
        }
        if (this.pathPrefix == null ? other.pathPrefix != null : !this.pathPrefix.equals(other.pathPrefix)) {
            return false;
        }
        return !(this.suffix == null ? other.suffix != null : !this.suffix.equals(other.suffix));
    }
}

