/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyes.starter.register;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.dromara.easyes.common.utils.EEVersionUtils;
import org.dromara.easyes.common.utils.LogUtils;
import org.dromara.easyes.starter.register.ClassPathMapperScanner;
import org.dromara.easyes.starter.register.EsMapperScan;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.StringUtils;

public class MapperScannerRegister
implements ImportBeanDefinitionRegistrar,
ResourceLoaderAware,
EnvironmentAware {
    private ResourceLoader resourceLoader;
    private Environment environment;

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        AnnotationAttributes mapperScanAttrs;
        Boolean enable = Optional.ofNullable(this.environment.getProperty("easy-es.enable")).map(Boolean::parseBoolean).orElse(Boolean.TRUE);
        if (!enable.booleanValue()) {
            LogUtils.info((String[])new String[]{"===> Easy-Es is not enabled"});
            return;
        }
        boolean banner = Optional.ofNullable(this.environment.getProperty("easy-es.banner")).map(Boolean::parseBoolean).orElse(Boolean.TRUE);
        if (banner) {
            boolean iKunMode = Optional.ofNullable(this.environment.getProperty("easy-es.global-config.i-kun-mode")).map(Boolean::parseBoolean).orElse(Boolean.FALSE);
            String versionStr = EEVersionUtils.getJarVersion(this.getClass());
            String wechatStr = ":: wechat    :: 252645816, add and become muscle man!      >";
            if (iKunMode) {
                System.out.println("                 \u9e21\u4f60\u592a\u7f8e\n               \u9e21\u4f60\u5b9e\u5728\u592a\u7f8e\n                \u9e21\u4f60\u662f\u592a\u7f8e\n                 \u9e21\u4f60\u592a\u7f8e\n              \u5b9e\u5728\u662f\u592a\u7f8e\u9e21\u4f60\n         \u9e21\u4f60 \u5b9e\u5728\u662f\u592a\u7f8e\u9e21\u4f60 \u7f8e\n       \u9e21\u4f60  \u5b9e\u5728\u662f\u592a\u7f8e\u9e21\u7f8e   \u592a\u7f8e\n      \u9e21\u4f60  \u5b9e\u5728\u662f\u592a\u7f8e\u9e21\u7f8e      \u592a\u7f8e\n    \u9e21\u4f60    \u5b9e\u5728\u662f\u592a\u7f8e\u9e21\u7f8e       \u592a\u7f8e\n   \u9e21\u4f60    \u9e21\u4f60\u5b9e\u5728\u662f\u7f8e\u592a\u7f8e    \u7f8e\u84dd\u7403\u7403\u7403\n\u9e21 \u9e21     \u9e21\u4f60\u5b9e\u5728\u662f\u592a\u7f8e     \u7bee\u7403\u7bee\u7403\u7403\u7403\u7403\n \u9e21      \u9e21\u4f60\u592a\u7f8e\u88c6\u9e21\u592a\u554a     \u7403\u7403\u84dd\u7bee\u7403\u7403\n         \u9e21\u4f60\u592a\u7f8e\u88c6\u88c6\u9e21\u7f8e       \u7403\u7403\u7403\n          \u9e21\u4f60\u88c6\u5c0f j \u9e21\u592a\u7f8e\n           \u9e21\u592a\u7f8e    \u9e21\u592a\u7f8e\n            \u9e21\u7f8e      \u9e21\u7f8e\n            \u9e21\u7f8e       \u9e21\u7f8e\n             \u9e21\u7f8e       \u9e21\u7f8e\n             \u9e21\u592a       \u9e21\u592a\n           \u9e21 \u811a       \u9e21\u811a\n           \u76ae \u978b       \u76ae\u978b\u91d1\u7334\n            \u91d1\u5149       \u91d1\u5149 \u5927\u9053\n           \u5927\u9053\n      \u9e21\u795e\u4fdd\u4f51       \u6c38\u4e0d\u5b95\u673a     \u6c38\u65e0BUG");
                wechatStr = ":: wechat    :: 252645816, add and join ikun(\u5c0f\u9ed1\u5b50) group! >";
            } else {
                System.out.println("\n___                     _  _            ___\n  | __|   __ _     ___    | || |   ___    | __|    ___\n  | _|   / _` |   (_-<     \\_, |  |___|   | _|    (_-<\n  |___|  \\__,_|   /__/_   _|__/   _____   |___|   /__/_\n_|\"\"\"\"\"|_|\"\"\"\"\"|_|\"\"\"\"\"|_| \"\"\"\"|_|     |_|\"\"\"\"\"|_|\"\"\"\"\"|\n\"`-0-0-'\"`-0-0-'\"`-0-0-'\"`-0-0-'\"`-0-0-'\"`-0-0-'\"`-0-0-'\n----------------------------------------------------------->");
            }
            int width = 43;
            int blank = width - versionStr.length();
            StringBuilder sb = new StringBuilder();
            sb.append(":: version   :: ").append(versionStr);
            for (int i = 0; i < blank; ++i) {
                sb.append(" ");
            }
            sb.append(">");
            if (iKunMode) {
                System.out.println("----------------------------------------------------------->");
            }
            System.out.println(":: project   :: Easy-Es                                    >");
            System.out.println(sb);
            System.out.println(":: home      :: https://easy-es.cn/                        >");
            System.out.println(":: community :: https://dromara.org/                       >");
            System.out.println(wechatStr);
            System.out.println("----------------------------------------------------------->");
        }
        if ((mapperScanAttrs = AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(EsMapperScan.class.getName()))) != null) {
            this.registerBeanDefinitions(mapperScanAttrs, registry);
        }
    }

    void registerBeanDefinitions(AnnotationAttributes annoAttrs, BeanDefinitionRegistry registry) {
        ClassPathMapperScanner scanner = new ClassPathMapperScanner(registry);
        Optional.ofNullable(this.resourceLoader).ifPresent(arg_0 -> ((ClassPathMapperScanner)scanner).setResourceLoader(arg_0));
        ArrayList basePackages = new ArrayList();
        basePackages.addAll(Arrays.stream(annoAttrs.getStringArray("value")).filter(StringUtils::hasText).collect(Collectors.toList()));
        scanner.registerFilters();
        scanner.doScan(StringUtils.toStringArray(basePackages));
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

