/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyes.starter;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import org.dromara.easyes.common.property.EasyEsDynamicProperties;
import org.dromara.easyes.common.property.EasyEsProperties;
import org.dromara.easyes.common.utils.EsClientUtils;
import org.dromara.easyes.spring.config.EasyEsConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;

@Configuration
@ConditionalOnClass(value={ElasticsearchClient.class})
@ConditionalOnProperty(prefix="easy-es", name={"enable"}, havingValue="true", matchIfMissing=true)
@AutoConfigureOrder(value=-2147483648)
public class EsAutoConfiguration {
    @Bean
    @ConfigurationProperties(prefix="easy-es")
    public EasyEsProperties easyEsProperties() {
        return new EasyEsProperties();
    }

    @Bean
    @ConfigurationProperties(prefix="easy-es.dynamic")
    public EasyEsDynamicProperties easyEsDynamicProperties() {
        return new EasyEsDynamicProperties();
    }

    @Bean
    @ConditionalOnMissingBean
    @DependsOn(value={"easyEsProperties", "easyEsDynamicProperties"})
    public ElasticsearchClient elasticClient() {
        return EsClientUtils.buildClient((EasyEsProperties)this.easyEsProperties());
    }

    @Bean
    public EasyEsConfiguration esConfiguration() {
        return new EasyEsConfiguration();
    }
}

