/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyes.common.utils;

import java.util.Collection;
import org.dromara.easyes.common.exception.EasyEsException;
import org.dromara.easyes.common.utils.CollectionUtils;

public class Assert {
    private Assert() {
    }

    public static void notNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isNull(Object object, String message) {
        if (object != null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isTrue(boolean expression, String message) {
        if (!expression) {
            throw new EasyEsException(message);
        }
    }

    public static void isFalse(boolean expression, String message) {
        if (expression) {
            throw new EasyEsException(message);
        }
    }

    public static void isEmpty(Object[] array, String message) {
        if (!Assert.isEmpty(array)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmpty(Object[] array, String message) {
        if (Assert.isEmpty(array)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmpty(Collection<?> collection, String message) {
        if (CollectionUtils.isEmpty(collection)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isEmpty(Collection<?> collection, String message) {
        if (CollectionUtils.isNotEmpty(collection)) {
            throw new IllegalArgumentException(message);
        }
    }

    private static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }
}

